% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mlpcr.R
\name{predict.mlpcr}
\alias{predict.mlpcr}
\title{Elastic Prediction for functional multinomial logistic PCR Model}
\usage{
\method{predict}{mlpcr}(object, newdata = NULL, y = NULL, ...)
}
\arguments{
\item{object}{Object of class inheriting from "elastic.pcr.regression"}

\item{newdata}{An optional matrix in which to look for variables with which to predict. If omitted, the fitted values are used.}

\item{y}{An optional vector of labels to calculate PC. If omitted, PC is NULL}

\item{...}{additional arguments affecting the predictions produced}
}
\value{
Returns a list containing
\item{y_pred}{predicted probabilities of the class of newdata}
\item{y_labels}{class labels of newdata}
\item{PC}{probability of classification per class}
\item{PC.comb}{total probability of classification}
}
\description{
This function performs prediction from an elastic multinomial logistic fPCR regression model
 with phase-variability
}
\references{
J. D. Tucker, J. R. Lewis, and A. Srivastava, “Elastic
 Functional Principal Component Regression,” Statistical Analysis and Data
 Mining, 10.1002/sam.11399, 2018.
}
\keyword{alignment}
\keyword{regression}
\keyword{srvf}
