% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elastic_regression.R
\name{elastic.regression}
\alias{elastic.regression}
\title{Elastic Linear Regression}
\usage{
elastic.regression(f, y, time, B = NULL, lam = 0, df = 20,
  max_itr = 20, smooth_data = FALSE, sparam = 25, parallel = FALSE,
  cores = 2)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{y}{vector of size \eqn{M} responses}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{B}{matrix defining basis functions (default = NULL)}

\item{lam}{scalar regularization parameter (default=0)}

\item{df}{scalar controlling degrees of freedom if B=NULL (default=20)}

\item{max_itr}{scalar number of iterations (default=20)}

\item{smooth_data}{smooth data using box filter (default = F)}

\item{sparam}{number of times to apply box filter (default = 25)}

\item{parallel}{enable parallel mode using \code{\link{foreach}} and
\code{doParallel} package}

\item{cores}{set number of cores to use with \code{doParallel} (default = 2)}
}
\value{
Returns a list containing
\item{alpha}{model intercept}
\item{beta}{regressor function}
\item{fn}{aligned functions - matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}
\item{qn}{aligned srvfs - similar structure to fn}
\item{gamma}{warping functions - similar structure to fn}
\item{q}{original srvf - similar structure to fn}
\item{B}{basis matrix}
\item{b}{basis coefficients}
\item{SSE}{sum of squared errors}
\item{type}{model type ('linear')}
}
\description{
This function identifies a regression model with phase-variability
using elastic methods
}
\references{
Tucker, J. D., Wu, W., Srivastava, A.,
 Elastic Functional Logistic Regression with Application to Physiological Signal Classification,
 Electronic Journal of Statistics (2014), submitted.
}
\keyword{alignment}
\keyword{regression}
\keyword{srvf}
