% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhaseBoxplot.R
\name{PhaseBoxplot}
\alias{PhaseBoxplot}
\title{SRVF transform of warping functions}
\usage{
PhaseBoxplot(gam, kp, showplot = T)
}
\arguments{
\item{gam}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} warping functions with \eqn{N} samples}

\item{kp}{scalar for outlier cutoff}

\item{showplot}{shows plots of functions (default = T)}
}
\value{
Returns a list containing \item{median_x}{median warping function}
\item{Q1}{First quartile}
\item{Q3}{Second quartile}
\item{minn}{minimum extreme function}
\item{maxx}{maximum extreme function}
\item{outlier_index}{indexes of outlier functions}
}
\description{
This function calculates the srvf of warping functions with corresponding
shooting vectors and finds the median
}
\examples{
data("simu_warp_median")
out = PhaseBoxplot(simu_warp_median$gam, 1)
}
\references{
Xie, W., S. Kurtek, K. Bharath, and Y. Sun  (2016). "A Geometric Approach to Visualization
of Variability in Functional Data." Journal of the American Statistical Association in press: 1-34.
}
\keyword{alignment}
\keyword{boxplot}
\keyword{srvf}
