% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.FPCA.R
\name{fitted.FPCA}
\alias{fitted.FPCA}
\title{Fitted functional data from FPCA object}
\usage{
\method{fitted}{FPCA}(object, K = NULL, derOptns = list(p = 0),
  ciOptns = list(alpha = NULL, cvgMethod = NULL), ...)
}
\arguments{
\item{object}{A object of class FPCA returned by the function FPCA().}

\item{K}{The integer number of the first K components used for the representation. (default: length(fpcaObj$lambda ))}

\item{derOptns}{A list of options to control the derivation parameters specified by \code{list(name=value)}. See `Details'. (default = NULL)}

\item{ciOptns}{A list of options to control the confidence interval/band specified by \code{list(name=value)}. See `Details'. (default = NULL)}

\item{...}{Additional arguments}
}
\value{
If \code{alpha} is \code{NULL}, \code{p>1} or functional observations are dense, an \code{n} by \code{length(workGrid)} matrix, each row of which contains a sample. Otherwise, it returns a list which consists of the following items:
\item{workGrid}{An evaluation grid for fitted values.}
\item{fitted}{An n by length(workGrid) matrix, each row of which contains a sample.}
\item{cvgUpper}{An n by length(workGrid) matrix, each row of which contains the upper \code{alpha}-coverage limit}
\item{cvgLower}{An n by length(workGrid) matrix, each row of which contains the lower \code{alpha}-coverage limit}
}
\description{
Combines the zero-meaned fitted values and the interpolated mean to get the fitted values for the trajectories 
or the derivatives of these trajectories.
Estimates are given on the work-grid, not on the observation grid. Use ConvertSupport 
to map the estimates to your desired domain. \code{100*(1-alpha)}-percentage coverage intervals, or 
bands, for trajectory estimates (not derivatives) are provided. For details consult the example.
}
\details{
Available derivation control options are 
\describe{
\item{p}{The order of the derivatives returned (default: 0, max: 2)}
\item{method}{The method used to produce the sample of derivatives ('FPC' (default) or 'QUO'). See Liu and Müller (2009) for more details}
\item{bw}{Bandwidth for smoothing the derivatives (default: p * 0.10 * S)}
\item{kernelType}{Smoothing kernel choice; same available types are FPCA(). default('epan')}
}

Available confidence interval/band control options are 
\describe{
\item{alpha}{Significant level for confidence interval/band for trajectory coverage. default=0.05 (currently only work when p=0)}
\item{cvgMethod}{Option for trajectory coverage method between 'interval' (pointwise coverage) and 'band' (simultaneous coverage). default='band'}
}
}
\examples{
set.seed(1)
n <- 100
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 5:10)
res <- FPCA(sampWiener$Ly, sampWiener$Lt, 
            list(dataType='Sparse', error=FALSE, kernel='epan', verbose=TRUE))
fittedY <- fitted(res, ciOptns = list(alpha=0.05))

workGrid <- res$workGrid
cvgUpper <- fittedY$cvgUpper
cvgLower <- fittedY$cvgLower

op <- par(mfrow=c(2,3))
ind <- sample(1:n,6)
for (i in 1:6) {
 j <- ind[i]
 plot(workGrid,cvgUpper[j,],type='l',ylim=c(min(cvgLower[j,]),max(cvgUpper[j,])),col=4,lty=2,
   xlab='t', ylab='X(t)', main=paste(j,'-th subject',sep=''))
 points(workGrid,cvgLower[j,],type='l',col=4,lty=2)
 points(res$inputData$Lt[[j]],res$inputData$Ly[[j]])
}
par(op)
    
}
\references{
\cite{Yao, F., Müller, H.-G. and Wang, J.-L. "Functional data analysis for sparse longitudinal data", Journal of the American Statistical Association, vol.100, No. 470 (2005): 577-590.}

\cite{Liu, Bitao, and Hans-Georg Müller. "Estimating derivatives for samples of sparsely observed functions, with application to online auction dynamics." Journal of the American Statistical Association 104, no. 486 (2009): 704-717. (Sparse data FPCA)}
}
