% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata.R
\name{fdata}
\alias{fdata}
\title{Converts raw data or other functional data classes into fdata class.}
\usage{
fdata(mdata, argvals = NULL, rangeval = NULL, names = NULL,
  fdata2d = FALSE)
}
\arguments{
\item{mdata}{Matrix of set cases with dimension (\code{n} x \code{m}), where
\code{n} is the number of curves and \code{m} are the points observed in
each curve.}

\item{argvals}{Argvals, by default: \code{1:m}.}

\item{rangeval}{(optional) Range of discretization points, by default:
range(\code{argvals}).}

\item{names}{(optional) list with tree components: \code{main} an overall
title, \code{xlab} title for \code{x} axis and \code{ylab} title for
\code{y} axis.}

\item{fdata2d}{TRUE class fdata2d, the functional data is observed in at
least a two grids (the \code{argvals} is a list of vectors). By default
\code{fdata2d=FALSE} the functional data is observed in a single grid (the
\code{argvals} is a vector).}
}
\value{
Return \code{fdata} class object with: 
\itemize{ 
\item \code{"data"}: matrix of set cases with dimension (\code{n} x \code{m}),
where \code{n} is the number of curves and \code{m} are the points observed
in each curve 
\item \code{"rangeval"}: the discretizations points values, if not provided: \code{1:m} 
\item \code{"rangeval"}: range of the discretizations points values, by default: range(\code{argvals}) 
\item \code{"names"}: (optional) list with \code{main} an overall title, \code{xlab}
title for \code{x} axis and \code{ylab} title for \code{y} axis.
}
}
\description{
Create a functional data object of class \code{fdata} from (\code{matrix},
\code{data.frame}, \code{numeric}, \code{integer}, \code{fd, fds, fts} or
\code{sfts}) class data.
}
\examples{
\dontrun{
data(phoneme)
mlearn<-phoneme$learn[1:4,1:150]
# Center curves
fdata.c=fdata.cen(mlearn)$Xcen
par(mfrow=c(2,1))
plot(mlearn,type="l")
plot(fdata.c,type="l")

# Convert  from class fda to fdata
bsp1 <- create.bspline.basis(c(1,150),21)
fd1 <- Data2fd(1:150,y=t(mlearn$data),basisobj=bsp1)
fdataobj=fdata(fd1)

# Convert  from class fds, fts or sfts to fdata
#require(fds)
#a=fds(x = 1:20, y = Simulationdata$y, xname = "x", 
# yname = "Simulated value")
#b=fts(x = 15:49, y = Australiasmoothfertility$y, xname = "Age",
#    yname = "Fertility rate")
#c=sfts(ts(as.numeric(ElNino_ERSST_region_1and2$y), frequency = 12), xname = "Month",
#yname = "Sea surface temperature")
#class(a);class(b);class(c)
#fdataobj=fdata(b)
}

}
\references{
Febrero-Bande, M., Oviedo de la Fuente, M. (2012).
\emph{Statistical Computing in Functional Data Analysis: The R Package
fda.usc.} Journal of Statistical Software, 51(4), 1-28.
\url{http://www.jstatsoft.org/v51/i04/}
}
\seealso{
See Also as \code{\link{plot.fdata}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{manip}
