###################################################
### chunk number 1: SourceR
###################################################
library(favir)
InitPaper()


###################################################
### chunk number 2: LatexPrelude
###################################################
IncludePrelude("Feature Tour", "Benedict Escoto")


###################################################
### chunk number 3: basicSweave
###################################################
2+2
1:10


###################################################
### chunk number 4: texOutput
###################################################
cat("\\begin{center}This LaTeX is generated by R\\end{center}")
cat(paste("\\[\\sum_{i=1}^{100} \\mbox{log}(i) \\approx ",
          sum(log(1:100)), "\\]"))


###################################################
### chunk number 5: hidden
###################################################
a <- 3
Assert(a == 3)
"You can't see this!"


###################################################
### chunk number 6: sweaveDF
###################################################
df <- data.frame(year=2000:2008,
                 prem.a=200000 * rnorm(9, 1, 0.1),
                 loss.a=130000 * rnorm(9, 1, 0.2),
                 loss.ratio.a=0,
                 prem.b=50000 * rnorm(9, 1, 0.1),
                 loss.b=30000 * rnorm(9, 1, 0.2),
                 loss.ratio.b=0)
df$loss.ratio.a <- df$loss.a / df$prem.a
df$loss.ratio.b <- df$loss.b / df$prem.b
df                 


###################################################
### chunk number 7: favirDF
###################################################
fdf <- FavirDF(df)
print(fdf)


###################################################
### chunk number 8: labelAndCaption
###################################################
Label(fdf) <- "with label"
Caption(fdf) <- "This FavirDF has a label and caption."
print(fdf)


###################################################
### chunk number 9: headings
###################################################
FieldHeadings(fdf) <- c(year="Calendar Year",
                        prem.a="Earned Premium Line A",
                        loss.a="Ultimate Loss Line A",
                        loss.ratio.a="Loss Ratio Line A",
                        prem.b="Earned Premium Line B",
                        loss.b="Ultimate Loss Line B",
                        loss.ratio.b="Loss Ratio Line B")
Label(fdf) <- "headings"
Caption(fdf) <- "Table with better column headings"
print(fdf)                        


###################################################
### chunk number 10: groupHeadings
###################################################
FieldGroup(fdf, "line.a") <- c("prem.a", "loss.a", "loss.ratio.a")
FieldGroup(fdf, "line.b") <- c("prem.b", "loss.b", "loss.ratio.b")
GroupHeading(fdf, "line.a") <- "Line of Business A"
GroupHeading(fdf, "line.b") <- "Line of Business B"
FieldHeadings(fdf) <- c(year="Calendar Year",
                        prem.a="Earned Premium",
                        loss.a="Ultimate Loss",
                        loss.ratio.a="Loss Ratio",
                        prem.b="Earned Premium",
                        loss.b="Ultimate Loss",
                        loss.ratio.b="Loss Ratio")

Label(fdf) <- "group headings"
Caption(fdf) <- "Table with group headings"
print(fdf)


###################################################
### chunk number 11: formattedFDF
###################################################
FieldFormatters(fdf) <- list(year=formatters$flat,
                             loss.ratio.a=formatters$percent,
                             loss.ratio.b=formatters$percent)
FieldHeadings(fdf) <- c("loss.ratio.a"="Loss Ratio (\\%)",
                        "loss.ratio.b"="Loss Ratio (\\%)")
Label(fdf) <- "formatted"
Caption(fdf) <- "Table with formatted entries"
print(fdf)


###################################################
### chunk number 12: finalFDF
###################################################
SummaryRow(fdf) <- list(year="Total",
                        prem.a=sum(fdf$prem.a),
                        loss.a=sum(fdf$loss.a),
                        loss.ratio.a=sum(fdf$loss.a) / sum(fdf$prem.a),
                        prem.b=sum(fdf$prem.b),
                        loss.b=sum(fdf$loss.b),
                        loss.ratio.b=sum(fdf$loss.b) / sum(fdf$prem.b))
Label(fdf) <- "final table"
Caption(fdf) <- "Final table with summary row"
print(fdf)


###################################################
### chunk number 13: basicGraph
###################################################
xvals <- -50:50
p1 <- qplot(x=xvals, y=xvals^2)
IncludeGraph(p1, caption="Basic graph with ggplot2", label="basic graph")


###################################################
### chunk number 14: basicGraph
###################################################
p2 <- qplot(x=xvals, y=xvals^2, geom="line")
IncludeGraph(p2, caption="Smaller Graph", label="small graph",
             height=5, width=5)


###################################################
### chunk number 15: grid
###################################################
p3 <- qplot(rnorm(500))
observations <- xvals^2 + rnorm(101, 0, 500)
p4 <- (qplot(xvals, observations)
       + geom_smooth(aes(x=xvals, y=observations))
       + geom_line(aes(x=xvals, y=xvals^2), color=favir.colors["M5"])
       + labs(x="X Values", y="Y Values (observed vs fitted vs true)"))
IncludeGrid(list("1.1"=p1, "1.2"=p2, "2.1"=p3, "2.2"=p4),
            label="grid", caption="Four separate plots in one grid")


###################################################
### chunk number 16: Legal
###################################################
IncludeLegal("FAViR Project", 2010)


