% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/force_plot.R
\name{force_plot}
\alias{force_plot}
\alias{force_plot.explain}
\title{Additive force plots}
\usage{
force_plot(object, ...)

\method{force_plot}{explain}(
  object,
  baseline = NULL,
  feature_values = NULL,
  display = c("viewer", "html"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{"explain"}.}

\item{...}{Additional optional arguments. (Currently ignored.)}

\item{baseline}{Numeric giving the average prediction across all the training
observations. \strong{NOTE:} It is recommended to provide this argument 
whenever \code{object} contains approximate Shapley values.}

\item{feature_values}{A matrix-like R object (e.g., a data frame or matrix) 
containing the corresponding feature values for the explanations in 
\code{object}.}

\item{display}{Character string specifying how to display the results. 
Current options are \code{"viewer"} (default) and \code{"html"}. The latter
is necessary for viewing the display inside of an \strong{rmarkdown} 
document.}
}
\description{
Visualize Shapley values with additive force style layouts from the Python
\href{https://github.com/slundberg/shap}{shap} package.
}
\details{
The resulting plot shows how each feature contributes to push the 
model output from the baseline prediction (i.e., the average predicted 
outcome over the entire training set `X`) to the corresponding model output. 
Features pushing the prediction higher are shown in red, while those pushing 
the prediction lower are shown in blue.
}
\note{
This function requires additional software to work. In particular,
users will need to make sure they have the following software installed:
\itemize{

  \item \href{https://www.python.org/}{Python} (>3.6);
  
  \item \href{https://github.com/slundberg/shap}{shap} (preferably >=0.36.0).
  
}
The \href{https://rstudio.github.io/reticulate/}{reticulate} package can be 
used to help make sure you're set up properly with the above dependencies.

It should also be noted that only exact Shapley explanations (i.e., calling 
\code{fastshap::explain()} with \code{exact = TRUE}) satisfy the so-called 
\emph{additivity property} where the sum of the feature contributions for 
\emph{x} must add up to the difference between the corresponding prediction 
for \emph{x} and the average of all the training predictions (i.e., the 
baseline). Consequently, if you don't set \code{adjust = TRUE} in the call to 
\code{\link{explain}} before using \code{fastshap::force_plot()}, the 
output value displayed on the plot will not make much sense.
}
\examples{
\dontrun{
#
# A projection pursuit regression (PPR) example
#

# Load the sample data; see ?datasets::mtcars for details
data(mtcars)

# Fit a projection pursuit regression model
mtcars.ppr <- ppr(mpg ~ ., data = mtcars, nterms = 1)

# Compute approximate Shapley values using 10 Monte Carlo simulations
set.seed(101)  # for reproducibility
shap <- explain(mtcars.ppr, X = subset(mtcars, select = -mpg), nsim = 10, 
                pred_wrapper = predict, adjust = TRUE)

# Visualize first explanation
preds <- predict(mtcars.ppr, newdata = mtcars)
x <- subset(mtcars, select = -mpg)[1L, ]  # take first row of feature values
force_plot(shap[1L, ], baseline = mean(preds), feature_values = x)
}
}
\references{
Lundberg, Scott M, Bala Nair, Monica S Vavilala, Mayumi Horibe, Michael J 
Eisses, Trevor Adams, David E Liston, et al. 2018. "Explainable 
Machine-Learning Predictions for the Prevention of Hypoxaemia During 
Surgery." Nature Biomedical Engineering 2 (10). Nature Publishing Group: 749.
}
