% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_plot.R
\name{qc_plot}
\alias{qc_plot}
\alias{print.qctable}
\title{Plot FastQC Results}
\usage{
qc_plot(qc, modules = "all")

\method{print}{qctable}(x, ...)
}
\arguments{
\item{qc}{An object of class qc_read or a path to the sample zipped fastqc result file.}

\item{modules}{Character vector containing the names of fastqc modules for
  which you want to import the data. Default is all. Allowed values include
  one or the combination of:
  \itemize{
  \item "Summary",
   \item "Basic Statistics",
   \item "Per base sequence quality",
   \item "Per sequence quality scores",
   \item "Per base sequence content",
   \item "Per sequence GC content",
   \item "Per base N content",
   \item "Sequence Length Distribution",
   \item "Sequence Duplication Levels",
   \item "Overrepresented sequences",
   \item "Adapter Content",
   \item "Kmer Content"
  }
Partial match of module names allowed. For example,
you can use modules = "GC content", instead of the full names modules = "Per sequence GC content".}

\item{x}{an object of class qctable.}

\item{...}{other arguments.}
}
\value{
Returns a list of ggplots containing the plot for specified modules..
}
\description{
Plot FastQC data
}
\examples{
# Demo file
qc.file <- system.file("fastqc_results", "S1_fastqc.zip",  package = "fastqcr")
qc.file
# Read all modules
qc <- qc_read(qc.file)

# Plot per sequence GC content
qc_plot(qc, "Per sequence GC content")

# Per base sequence quality
qc_plot(qc, "Per base sequence quality")

# Per sequence quality scores
qc_plot(qc, "Per sequence quality scores")

# Per base sequence content
qc_plot(qc, "Per base sequence content")

# Sequence duplication levels
qc_plot(qc, "Sequence duplication levels")


}
