# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Run a single sequential study to find a critical n.
#' @param x_pop First vector of population.
#' @param y_pop Second vector of population.
#' @param index_pop Vector from 1:length(x_pop) (more efficient than to
#'   create).
#' @param lower_limit Lower limit of corridor of stability.
#' @param upper_limit Upper limit of corridor of stability.
#' @param replace Whether drawing samples is with replacement or not.
#' @param sample_size_max How many participants to draw at maximum.
#' @param sample_size_min Minimum sample size to start in corridor of
#'   stability.
#' @return Sample size where corridor of stability is reached.
#' @noRd
simulate_one_pos <- function(x_pop, y_pop, index_pop, sample_size_min, sample_size_max, replace, lower_limit, upper_limit) {
    .Call('_fastpos_simulate_one_pos', PACKAGE = 'fastpos', x_pop, y_pop, index_pop, sample_size_min, sample_size_max, replace, lower_limit, upper_limit)
}

#' Simulate several points of stability
#'
#' Runs several simulations and returns the points of stability, which can then
#' be further processed to calculate the critical point of stability. This
#' function should only be used if you need the specific points of stability.
#' For instance, if you want to study the method in more detail and the higher
#' level functions are not sufficient.
#'
#' If you just want to calculate a quantile of the distribution, use the main
#' function of the package [fastpos::find_critical_pos()]).
#'
#' @param x_pop First vector of population.
#' @param y_pop Second vector of population.
#' @param lower_limit Lower limit of corridor of stability.
#' @param upper_limit Upper limit of corridor of stability.
#' @param replace Whether drawing samples is with replacement or not.
#' @param sample_size_max How many participants to draw at maximum.
#' @param n_studies How many studies to conduct.
#' @param sample_size_min Minimum sample size to start in corridor of
#'   stability.
#' @param progress Should progress bar be displayed? Boolean, default is FALSE.
#' @return Vector of sample sizes at which corridor of stability was reached.
#' @examples
#' # set up a population
#' pop <- fastpos::create_pop(rho = 0.5, size = 1e6)
#' # create a distribution of points of stability
#' pos <- simulate_pos(x_pop = pop[,1], y_pop = pop[,2], n_studies = 100,
#'                     sample_size_min = 20, sample_size_max = 1e3,
#'                     replace = TRUE, lower_limit = 0.4, upper_limit = 0.6,
#'                     progress = TRUE)
#' # calculate quantiles or any other parameter of the distribution
#' quantile(pos, c(.8, .9, .95))
#' @export
simulate_pos <- function(x_pop, y_pop, n_studies, sample_size_min, sample_size_max, replace, lower_limit, upper_limit, progress) {
    .Call('_fastpos_simulate_pos', PACKAGE = 'fastpos', x_pop, y_pop, n_studies, sample_size_min, sample_size_max, replace, lower_limit, upper_limit, progress)
}

