% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grassGUI.r
\name{grassGUI,missing-method}
\alias{grassGUI,missing-method}
\alias{grassGUI}
\title{Start the GRASS GUI (potentially dangerous!)}
\usage{
\S4method{grassGUI}{missing}()
}
\value{
Nothing (starts the \strong{GRASS} GUI).
}
\description{
This function starts the \strong{GRASS} GUI. It is provided merely as a utility... in most cases, it should \emph{not} be used if you are doing any kind of analysis of rasters or vectors using \strong{fasterRaster}. The reason for this prohibition is that \strong{fasterRaster} objects, like \code{GRaster}s and \code{GVector}s, are really "pointers" to objects in \strong{GRASS}. If \strong{fasterRaster} points to a \strong{GRASS} object that is changed in \strong{GRASS} but not \strong{R}, then \strong{fasterRaster} will not "know" about it, so changed won't be reflected in the \strong{fasterRaster} object.

One aspect of the GUI that is useful but will not change objects is to use it to plot rasters and vectors. However, the a \strong{fasterRaster} object in \strong{R} will have a different name in \strong{GRASS}. The name in \strong{GRASS} of a \code{GVector} or \code{GRaster} is given by \code{\link[=sources]{sources()}}.
}
\examples{
if (grassStarted()) {

# DANGER: Making changes to rasters/vectors in the GUI can "break" them in R.
if (interactive()) grassGUI()

}
}
\seealso{
\code{\link[=mow]{mow()}}
}
