% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd.R
\name{fastcpd_arma}
\alias{fastcpd_arma}
\alias{fastcpd.arma}
\title{Find change points efficiently in ARMA(\eqn{p}, \eqn{q}) models}
\usage{
fastcpd_arma(data, order = c(0, 0), ...)

fastcpd.arma(data, order = c(0, 0), ...)
}
\arguments{
\item{data}{A numeric vector, a matrix, a data frame or a time series object.}

\item{order}{A vector of length two specifying the order of the ARMA
model.}

\item{...}{Other arguments passed to \code{\link[=fastcpd]{fastcpd()}}, for example,
\code{segment_count}.}
}
\value{
A \linkS4class{fastcpd} object.
}
\description{
\code{\link[=fastcpd_arma]{fastcpd_arma()}} and \code{\link[=fastcpd.arma]{fastcpd.arma()}} are
wrapper functions of \code{\link[=fastcpd]{fastcpd()}} to find change points in
ARMA(\eqn{p}, \eqn{q}) models. The function is similar to \code{\link[=fastcpd]{fastcpd()}}
except that the data is by default a one-column matrix or univariate vector
and thus a formula is not required here.
}
\examples{
\donttest{
set.seed(1)
n <- 200
w <- rnorm(n + 3, 0, 3)
x <- rep(0, n + 3)
for (i in 1:150) {
  x[i + 3] <- 0.1 * x[i + 2] - 0.3 * x[i + 1] + 0.1 * x[i] +
    0.1 * w[i + 2] + 0.5 * w[i + 1] + w[i + 3]
}
for (i in 151:n) {
  x[i + 3] <- 0.3 * x[i + 2] + 0.1 * x[i + 1] - 0.3 * x[i] -
    0.6 * w[i + 2] - 0.1 * w[i + 1] + w[i + 3]
}
result <- suppressWarnings(
  fastcpd.arma(
    data = x[3 + seq_len(n)],
    order = c(3, 2),
    segment_count = 3,
    lower = c(rep(-1, 3 + 2), 1e-10),
    upper = c(rep(1, 3 + 2), Inf),
    line_search = c(1, 0.1, 1e-2),
    beta = "BIC",
    cost_adjustment = "BIC",
    trim = 0.025
  )
)
summary(result)
plot(result)
}
}
\seealso{
\code{\link[=fastcpd]{fastcpd()}}
}
