% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd.binomial}
\alias{fastcpd.binomial}
\alias{fastcpd_binomial}
\title{Find change points efficiently in logistic regression models}
\usage{
fastcpd.binomial(data, ...)

fastcpd_binomial(data, ...)
}
\arguments{
\item{data}{A matrix or a data frame with the response variable as the first
column.}

\item{...}{Other arguments passed to \code{\link{fastcpd}}, for example,
\code{segment_count}.}
}
\value{
A class \code{fastcpd} object.
}
\description{
\code{"fastcpd_binomial"} and \code{"fastcpd.binomial"} are
wrapper functions of \code{\link{fastcpd}} to find change points in
logistic regression models. The function is similar to \code{"fastcpd"}
except that the data is by default a matrix or data frame with the response
variable as the first column and thus a formula is not required here.
}
\examples{
if (!requireNamespace("ggplot2", quietly = TRUE)) utils::install.packages(
  "ggplot2", repos = "https://cloud.r-project.org", quiet = TRUE
)

set.seed(1)
x <- matrix(rnorm(1500, 0, 1), ncol = 5)
theta <- rbind(rnorm(5, 0, 1), rnorm(5, 2, 1))
y <- c(
  rbinom(125, 1, 1 / (1 + exp(-x[1:125, ] \%*\% theta[1, ]))),
  rbinom(175, 1, 1 / (1 + exp(-x[126:300, ] \%*\% theta[2, ])))
)
result <- suppressWarnings(fastcpd.binomial(cbind(y, x)))
summary(result)
plot(result)
}
