% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{traffic}
\alias{traffic}
\title{New England traffic fatalities (1951-1959)}
\format{A data frame with 9 observations on the following 6 variables.
\itemize{ \item{year}{ a year from 1951 to 1959}
\item{cn.deaths}{ number of traffic deaths in Connecticut}
\item{ny}{ deaths per 100,000 in New York} \item{cn}{ deaths
per 100,000 in Connecticut} \item{ma}{ deaths per 100,000 in
Massachusetts} \item{ri}{ deaths per 100,000 in in Rhode Island} }}
\source{
Tufte, E. R.  \emph{The Visual Display of Quantitative Information},
2nd ed. Graphics Press, 2001.
}
\description{
Used by Tufte as an example of the importance of context, these data show
the traffic fatality rates in New England in the 1950s.  Connecticut
increased enforcement of speed limits in 1956.  In their full context, it is
difficult to say if the decline in Connecticut traffic fatalities from 1955
to 1956 can be attributed to the stricter enforcement.
}
\examples{
data(traffic)
xyplot(cn.deaths ~ year, data=traffic, type=c('l','g'))
trafficLong <- reshape(traffic,direction='long', idvar="year",
				varying=list(3:6), v.names='deathRate',
				times=names(traffic)[3:6], timevar='state')
xyplot(deathRate~year, groups=state, data=trafficLong, type='b',
		auto.key=list(lines=TRUE, points=FALSE, columns=2))
}
\references{
Donald T. Campbell and H. Laurence Ross. "The Connecticut
Crackdown on Speeding: Time-Series Data in Quasi-Experimental Analysis",
\emph{Law \& Society Review} Vol. 3, No. 1 (Aug., 1968), pp. 33-54.

Gene V. Glass. "Analysis of Data on the Connecticut Speeding Crackdown as a
Time-Series Quasi-Experiment" \emph{Law & Society Review}, Vol. 3, No. 1
(Aug., 1968), pp. 55-76.
}
\keyword{datasets}

