\docType{data}
\name{corn}
\alias{corn}
\title{Corn Yield}
\format{A data frame with 11 observations on the following 2 variables.
\itemize{ \item{reg}{yield of regular corn (lbs/acre)}
\item{kiln}{yield of kiln-dried corn (lbs/acre)} }}
\source{
  These data are also available at DASL, the data and story
  library (\url{http://lib.stat.cmu.edu/DASL/}).
}
\description{
  William Gosset analyzed data from an experiment comparing
  the yield of regular and kiln-dried corn.
}
\details{
  Gosset (Student) reported on the results of seeding plots
  with two different kinds of seed. Each type of seed
  (regular and kiln-dried) was planted in adjacent plots,
  accounting for 11 pairs of "split" plots.
}
\examples{
corn2 <- stack(corn)
names(corn2) <- c('yield','treatment')
lm(yield ~ treatment, corn2)
t.test(yield ~ treatment, corn2)
t.test(corn$reg,corn$kiln)
}
\references{
  W.S. Gosset, "The Probable Error of a Mean," Biometrika,
  6 (1908), pp 1-25.
}
\keyword{datasets}

