\name{wavesolder}
\alias{wavesolder}
\docType{data}
\title{Defects in a wave soldering process}
\description{
  Components are attached to an electronic circuit card assembly by
  a wave-soldering process. The soldering process involves baking and
  preheating the circuit card and then passing it through a solder wave
  by conveyor. Defect arise during the process. Design is \eqn{2^{7-3}} with
  3 replicates.
}
\usage{data(wavesolder)}
\format{
  A data frame with 16 observations on the following 10 variables.
  \describe{
    \item{y1}{Number of defects in the first replicate}
    \item{y2}{Number of defects in the second replicate}
    \item{y3}{Number of defects in the third replicate}
    \item{prebake}{prebake condition - a factor with levels \code{1} \code{2}}
    \item{flux}{flux density - a factor with levels \code{1} \code{2}}
    \item{speed}{conveyor speed - a factor with levels \code{1} \code{2}}
    \item{preheat}{preheat condition - a factor with levels \code{1} \code{2}}
    \item{cooling}{cooling time - a factor with levels \code{1} \code{2}}
    \item{agitator}{ultrasonic solder agitator - a factor with levels \code{1} \code{2}}
    \item{temp}{solder temperature - facctor with levels \code{1} \code{2}}
  }
}
\source{
  L. Condra (1993) Reliability improvement with design of
  experiments. Marcel Dekker, NY.
}
\references{
  M. Hamada and J. Nelder (1997) Generalized linear models for quality
  improvement experiments, Journal of Quality Technology, 29, 292-304
}
\keyword{datasets}
