% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarS4Classes.R
\docType{class}
\name{familiarEnsemble-class}
\alias{familiarEnsemble-class}
\title{Ensemble of familiar models.}
\description{
A familiarEnsemble object contains one or more familiarModel objects.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the familiarEnsemble object.}

\item{\code{model_list}}{List of attached familiarModel objects, or paths to these
objects. Familiar attaches familiarModel objects when required.}

\item{\code{outcome_type}}{Outcome type of the data used to create the object.}

\item{\code{outcome_info}}{Outcome information object, which contains additional
information concerning the outcome, such as class levels.}

\item{\code{data_column_info}}{Data information object containing information
regarding identifier column names and outcome column names.}

\item{\code{learner}}{Learning algorithm used to create the models in the ensemble.}

\item{\code{fs_method}}{Feature selection method used to determine variable
importance for the models in the ensemble.}

\item{\code{feature_info}}{List of objects containing feature information, e.g.,
name, class levels, transformation, normalisation and clustering
parameters.}

\item{\code{required_features}}{The set of features required for complete
reproduction, i.e. with imputation.}

\item{\code{model_features}}{The combined set of features that is used to train the
models in the ensemble,}

\item{\code{novelty_features}}{The combined set of features that is used to train
all novelty detectors in the ensemble.}

\item{\code{run_table}}{Run table for the data used to train the ensemble. Used
internally.}

\item{\code{calibration_info}}{Calibration information, e.g. baseline survival in the
development cohort.}

\item{\code{model_dir_path}}{Path to folder containing the familiarModel objects. Can
be updated using the \code{update_model_dir_path} method.}

\item{\code{auto_detach}}{Flag used to determine whether models should be detached
from the model after use, or not. Used internally.}

\item{\code{settings}}{A copy of the evaluation configuration parameters used at
model creation. These are used as default parameters when evaluating the
ensemble to create a familiarData object.}

\item{\code{project_id}}{Identifier of the project that generated the
underlying familiarModel object(s).}

\item{\code{familiar_version}}{Version of the familiar package.}
}}

