% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Familiar.R
\name{summon_familiar}
\alias{summon_familiar}
\title{Perform end-to-end machine learning and data analysis}
\usage{
summon_familiar(
  formula = NULL,
  data = NULL,
  cl = NULL,
  config = NULL,
  config_id = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{formula}{An R formula. The formula can only contain feature names and
dot (\code{.}). The \code{*} and \code{+1} operators are not supported as these refer to
columns that are not present in the data set.

Use of the formula interface is optional.}

\item{data}{A \code{data.table} object, a \code{data.frame} object, list containing
multiple \code{data.table} or \code{data.frame} objects, or paths to data files.

\code{data} should be provided if no file paths are provided to the \code{data_files}
argument. If both are provided, only \code{data} will be used.

All data is expected to be in wide format, and ideally has a sample
identifier (see \code{sample_id_column}), batch identifier (see \code{cohort_column})
and outcome columns (see \code{outcome_column}).

In case paths are provided, the data should be stored as \code{csv}, \code{rds} or
\code{RData} files. See documentation for the \code{data_files} argument for more
information.}

\item{cl}{Cluster created using the \code{parallel} package. This cluster is then
used to speed up computation through parallelisation. When a cluster is not
provided, parallelisation is performed by setting up a cluster on the local
machine.

This parameter has no effect if the \code{parallel} argument is set to \code{FALSE}.}

\item{config}{List containing configuration parameters, or path to an \code{xml}
file containing these parameters. An empty configuration file can obtained
using the \code{get_xml_config} function.

All parameters can also be set programmatically. These supersede any
arguments derived from the configuration list.}

\item{config_id}{Identifier for the configuration in case the list or \code{xml}
table indicated by \code{config} contains more than one set of configurations.}

\item{verbose}{Indicates verbosity of the results. Default is TRUE, and all
messages and warnings are returned.}

\item{...}{
  Arguments passed on to \code{\link[=.parse_file_paths]{.parse_file_paths}}, \code{\link[=.parse_experiment_settings]{.parse_experiment_settings}}, \code{\link[=.parse_setup_settings]{.parse_setup_settings}}, \code{\link[=.parse_preprocessing_settings]{.parse_preprocessing_settings}}, \code{\link[=.parse_feature_selection_settings]{.parse_feature_selection_settings}}, \code{\link[=.parse_model_development_settings]{.parse_model_development_settings}}, \code{\link[=.parse_hyperparameter_optimisation_settings]{.parse_hyperparameter_optimisation_settings}}, \code{\link[=.parse_evaluation_settings]{.parse_evaluation_settings}}
  \describe{
    \item{\code{project_dir}}{(\emph{optional}) Path to the project directory. \code{familiar}
checks if the directory indicated by \code{experiment_dir} and data files in
\code{data_file} are relative to the \code{project_dir}.}
    \item{\code{experiment_dir}}{(\strong{recommended}) Path to the directory where all
intermediate and final results produced by \code{familiar} are written to.

The \code{experiment_dir} can be a path relative to \code{project_dir} or an absolute
path.

In case no project directory is provided and the experiment directory is
not on an absolute path, a directory will be created in the temporary R
directory indicated by \code{tempdir()}. This directory is deleted after closing
the R session or once data analysis has finished. All information will be
lost afterwards. Hence, it is recommended to provide either
\code{experiment_dir} as an absolute path, or provide both \code{project_dir} and
\code{experiment_dir}.}
    \item{\code{data_file}}{(\emph{optional}) Path to files containing data that should be
analysed. The paths can be relative to \code{project_dir} or absolute paths. An
error will be raised if the file cannot be found.

The following types of data are supported.
\itemize{
\item \code{csv} files containing column headers on the first row, and samples per
row. \code{csv} files are read using \code{data.table::fread}.
\item \code{rds} files that contain a \code{data.table} or \code{data.frame} object. \code{rds}
files are imported using \code{base::readRDS}.
\item \code{RData} files that contain a single \code{data.table} or \code{data.frame} object.
\code{RData} files are imported using \code{base::load}.
}

All data are expected in wide format, with sample information organised
row-wise.

More than one data file can be provided. \code{familiar} will try to combine
data files based on column names and identifier columns.

Alternatively, data can be provided using the \code{data} argument. These data
are expected to be \code{data.frame} or \code{data.table} objects or paths to data
files. The latter are handled in the same way as file paths provided to
\code{data_file}.}
    \item{\code{batch_id_column}}{(\strong{recommended}) Name of the column containing batch
or cohort identifiers. This parameter is required if more than one dataset
is provided, or if external validation is performed.

In familiar any row of data is organised by four identifiers:
\itemize{
\item The batch identifier \code{batch_id_column}: This denotes the group to which a
set of samples belongs, e.g. patients from a single study, samples measured
in a batch, etc. The batch identifier is used for batch normalisation, as
well as selection of development and validation datasets.
\item The sample identifier \code{sample_id_column}: This denotes the sample level,
e.g. data from a single individual. Subsets of data, e.g. bootstraps or
cross-validation folds, are created at this level.
\item The series identifier \code{series_id_column}: Indicates measurements on a
single sample that may not share the same outcome value, e.g. a time
series, or the number of cells in a view.
\item The repetition identifier: Indicates repeated measurements in a single
series where any feature values may differ, but the outcome does not.
Repetition identifiers are always implicitly set when multiple entries for
the same series of the same sample in the same batch that share the same
outcome are encountered.
}}
    \item{\code{sample_id_column}}{(\strong{recommended}) Name of the column containing
sample or subject identifiers. See \code{batch_id_column} above for more
details.

If unset, every row will be identified as a single sample.}
    \item{\code{series_id_column}}{(\strong{optional}) Name of the column containing series
identifiers, which distinguish between measurements that are part of a
series for a single sample. See \code{batch_id_column} above for more details.

If unset, rows which share the same batch and sample identifiers but have a
different outcome are assigned unique series identifiers.}
    \item{\code{development_batch_id}}{(\emph{optional}) One or more batch or cohort
identifiers to constitute data sets for development. Defaults to all, or
all minus the identifiers in \code{validation_batch_id} for external validation.
Required if external validation is performed and \code{validation_batch_id} is
not provided.}
    \item{\code{validation_batch_id}}{(\emph{optional}) One or more batch or cohort
identifiers to constitute data sets for external validation. Defaults to
all data sets except those in \code{development_batch_id} for external
validation, or none if not. Required if \code{development_batch_id} is not
provided.}
    \item{\code{outcome_name}}{(\emph{optional}) Name of the modelled outcome. This name will
be used in figures created by \code{familiar}.

If not set, the column name in \code{outcome_column} will be used for
\code{binomial}, \code{multinomial}, \code{count} and \code{continuous} outcomes. For other
outcomes (\code{survival} and \code{competing_risk}) no default is used.}
    \item{\code{outcome_column}}{(\strong{recommended}) Name of the column containing the
outcome of interest. May be identified from a formula, if a formula is
provided as an argument. Otherwise an error is raised. Note that \code{survival}
and \code{competing_risk} outcome type outcomes require two columns that
indicate the time-to-event or the time of last follow-up and the event
status.}
    \item{\code{outcome_type}}{(\strong{recommended}) Type of outcome found in the outcome
column. The outcome type determines many aspects of the overall process,
e.g. the available feature selection methods and learners, but also the
type of assessments that can be conducted to evaluate the resulting models.
Implemented outcome types are:
\itemize{
\item \code{binomial}: categorical outcome with 2 levels.
\item \code{multinomial}: categorical outcome with 2 or more levels.
\item \code{count}: Poisson-distributed numeric outcomes.
\item \code{continuous}: general continuous numeric outcomes.
\item \code{survival}: survival outcome for time-to-event data.
}

If not provided, the algorithm will attempt to obtain outcome_type from
contents of the outcome column. This may lead to unexpected results, and we
therefore advise to provide this information manually.

Note that \code{competing_risk} survival analysis are not fully supported, and
is currently not a valid choice for \code{outcome_type}.}
    \item{\code{class_levels}}{(\emph{optional}) Class levels for \code{binomial} or \code{multinomial}
outcomes. This argument can be used to specify the ordering of levels for
categorical outcomes. These class levels must exactly match the levels
present in the outcome column.}
    \item{\code{event_indicator}}{(\strong{recommended}) Indicator for events in \code{survival}
and \code{competing_risk} analyses. \code{familiar} will automatically recognise \code{1},
\code{true}, \code{t}, \code{y} and \code{yes} as event indicators, including different
capitalisations. If this parameter is set, it replaces the default values.}
    \item{\code{censoring_indicator}}{(\strong{recommended}) Indicator for right-censoring in
\code{survival} and \code{competing_risk} analyses. \code{familiar} will automatically
recognise \code{0}, \code{false}, \code{f}, \code{n}, \code{no} as censoring indicators, including
different capitalisations. If this parameter is set, it replaces the
default values.}
    \item{\code{competing_risk_indicator}}{(\strong{recommended}) Indicator for competing
risks in \code{competing_risk} analyses. There are no default values, and if
unset, all values other than those specified by the \code{event_indicator} and
\code{censoring_indicator} parameters are considered to indicate competing
risks.}
    \item{\code{signature}}{(\emph{optional}) One or more names of feature columns that are
considered part of a specific signature. Features specified here will
always be used for modelling. Ranking from feature selection has no effect
for these features.}
    \item{\code{novelty_features}}{(\emph{optional}) One or more names of feature columns
that should be included for the purpose of novelty detection.}
    \item{\code{exclude_features}}{(\emph{optional}) Feature columns that will be removed
from the data set. Cannot overlap with features in \code{signature},
\code{novelty_features} or \code{include_features}.}
    \item{\code{include_features}}{(\emph{optional}) Feature columns that are specifically
included in the data set. By default all features are included. Cannot
overlap with \code{exclude_features}, but may overlap \code{signature}. Features in
\code{signature} and \code{novelty_features} are always included. If both
\code{exclude_features} and \code{include_features} are provided, \code{include_features}
takes precedence, provided that there is no overlap between the two.}
    \item{\code{experimental_design}}{(\strong{required}) Defines what the experiment looks
like, e.g. \code{cv(bt(fs,20)+mb,3,2)+ev} for 2 times repeated 3-fold
cross-validation with nested feature selection on 20 bootstraps and
model-building, and external validation. The basic workflow components are:
\itemize{
\item \code{fs}: (required) feature selection step.
\item \code{mb}: (required) model building step.
\item \code{ev}: (optional) external validation. Note that internal validation due
to subsampling will always be conducted if the subsampling methods create
any validation data sets.
}

The different components are linked using \code{+}.

Different subsampling methods can be used in conjunction with the basic
workflow components:
\itemize{
\item \code{bs(x,n)}: (stratified) .632 bootstrap, with \code{n} the number of
bootstraps. In contrast to \code{bt}, feature pre-processing parameters and
hyperparameter optimisation are conducted on individual bootstraps.
\item \code{bt(x,n)}: (stratified) .632 bootstrap, with \code{n} the number of
bootstraps. Unlike \code{bs} and other subsampling methods, no separate
pre-processing parameters or optimised hyperparameters will be determined
for each bootstrap.
\item \code{cv(x,n,p)}: (stratified) \code{n}-fold cross-validation, repeated \code{p} times.
Pre-processing parameters are determined for each iteration.
\item \code{lv(x)}: leave-one-out-cross-validation. Pre-processing parameters are
determined for each iteration.
\item \code{ip(x)}: imbalance partitioning for addressing class imbalances on the
data set. Pre-processing parameters are determined for each partition. The
number of partitions generated depends on the imbalance correction method
(see the \code{imbalance_correction_method} parameter). Imbalance partitioning
does not generate validation sets.
}

As shown in the example above, sampling algorithms can be nested.

The simplest valid experimental design is \code{fs+mb}, which corresponds to a
TRIPOD type 1a analysis. Type 1b analyses are only possible using
bootstraps, e.g. \code{bt(fs+mb,100)}. Type 2a analyses can be conducted using
cross-validation, e.g. \code{cv(bt(fs,100)+mb,10,1)}. Depending on the origin of
the external validation data, designs such as \code{fs+mb+ev} or
\code{cv(bt(fs,100)+mb,10,1)+ev} constitute type 2b or type 3 analyses. Type 4
analyses can be done by obtaining one or more \code{familiarModel} objects from
others and applying them to your own data set.

Alternatively, the \code{experiment_design} parameter may be used to provide a
path to a file containing iterations, which is named \verb{####_iterations.RDS}
by convention. This path can be relative to the directory of the current
experiment (\code{experiment_dir}), or an absolute path. The absolute path may
thus also point to a file from a different experiment.}
    \item{\code{imbalance_correction_method}}{(\emph{optional}) Type of method used to
address class imbalances. Available options are:
\itemize{
\item \code{full_undersampling} (default): All data will be used in an ensemble
fashion. The full minority class will appear in each partition, but
majority classes are undersampled until all data have been used.
\item \code{random_undersampling}: Randomly undersamples majority classes. This is
useful in cases where full undersampling would lead to the formation of
many models due major overrepresentation of the largest class.
}

This parameter is only used in combination with imbalance partitioning in
the experimental design, and \code{ip} should therefore appear in the string
that defines the design.}
    \item{\code{imbalance_n_partitions}}{(\emph{optional}) Number of times random
undersampling should be repeated. 10 undersampled subsets with balanced
classes are formed by default.}
    \item{\code{parallel}}{(\emph{optional}) Enable parallel processing. Defaults to \code{TRUE}.
When set to \code{FALSE}, this disables all parallel processing, regardless of
specific parameters such as \code{parallel_preprocessing}. However, when
\code{parallel} is \code{TRUE}, parallel processing of different parts of the
workflow can be disabled by setting respective flags to \code{FALSE}.}
    \item{\code{parallel_nr_cores}}{(\emph{optional}) Number of cores available for
parallelisation. Defaults to 2. This setting does nothing if
parallelisation is disabled.}
    \item{\code{restart_cluster}}{(\emph{optional}) Restart nodes used for parallel computing
to free up memory prior to starting a parallel process. Note that it does
take time to set up the clusters. Therefore setting this argument to \code{TRUE}
may impact processing speed. This argument is ignored if \code{parallel} is
\code{FALSE} or the cluster was initialised outside of familiar. Default is
\code{FALSE}, which causes the clusters to be initialised only once.}
    \item{\code{cluster_type}}{(\emph{optional}) Selection of the cluster type for parallel
processing. Available types are the ones supported by the parallel package
that is part of the base R distribution: \code{psock} (default), \code{fork}, \code{mpi},
\code{nws}, \code{sock}. In addition, \code{none} is available, which also disables
parallel processing.}
    \item{\code{backend_type}}{(\emph{optional}) Selection of the backend for distributing
copies of the data. This backend ensures that only a single master copy is
kept in memory. This limits memory usage during parallel processing.

Several backend options are available, notably \code{socket_server}, and \code{none}
(default). \code{socket_server} is based on the callr package and R sockets,
comes with \code{familiar} and is available for any OS. \code{none} uses the package
environment of familiar to store data, and is available for any OS.
However, \code{none} requires copying of data to any parallel process, and has a
larger memory footprint.}
    \item{\code{server_port}}{(\emph{optional}) Integer indicating the port on which the
socket server or RServe process should communicate. Defaults to port 6311.
Note that ports 0 to 1024 and 49152 to 65535 cannot be used.}
    \item{\code{feature_max_fraction_missing}}{(\emph{optional}) Numeric value between \code{0.0}
and \code{0.95} that determines the meximum fraction of missing values that
still allows a feature to be included in the data set. All features with a
missing value fraction over this threshold are not processed further. The
default value is \code{0.30}.}
    \item{\code{sample_max_fraction_missing}}{(\emph{optional}) Numeric value between \code{0.0}
and \code{0.95} that determines the maximum fraction of missing values that
still allows a sample to be included in the data set. All samples with a
missing value fraction over this threshold are excluded and not processed
further. The default value is \code{0.30}.}
    \item{\code{filter_method}}{(\emph{optional}) One or methods used to reduce
dimensionality of the data set by removing irrelevant or poorly
reproducible features.

Several method are available:
\itemize{
\item \code{none} (default): None of the features will be filtered.
\item \code{low_variance}: Features with a variance below the
\code{low_var_minimum_variance_threshold} are filtered. This can be useful to
filter, for example, genes that are not differentially expressed.
\item \code{univariate_test}: Features undergo a univariate regression using an
outcome-appropriate regression model. The p-value of the model coefficient
is collected. Features with coefficient p or q-value above the
\code{univariate_test_threshold} are subsequently filtered.
\item \code{robustness}: Features that are not sufficiently robust according to the
intraclass correlation coefficient are filtered. Use of this method
requires that repeated measurements are present in the data set, i.e. there
should be entries for which the sample and cohort identifiers are the same.
}

More than one method can be used simultaneously. Features with singular
values are always filtered, as these do not contain information.}
    \item{\code{univariate_test_threshold}}{(\emph{optional}) Numeric value between \code{1.0} and
\code{0.0} that determines which features are irrelevant and will be filtered by
the \code{univariate_test}. The p or q-values are compared to this threshold.
All features with values above the threshold are filtered. The default
value is \code{0.20}.}
    \item{\code{univariate_test_threshold_metric}}{(\emph{optional}) Metric used with the to
compare the \code{univariate_test_threshold} against. The following metrics can
be chosen:
\itemize{
\item \code{p_value} (default): The unadjusted p-value of each feature is used for
to filter features.
\item \code{q_value}: The q-value (Story, 2002), is used to filter features. Some
data sets may have insufficient samples to compute the q-value. The
\code{qvalue} package must be installed from Bioconductor to use this method.
}}
    \item{\code{univariate_test_max_feature_set_size}}{(\emph{optional}) Maximum size of the
feature set after the univariate test. P or q values of features are
compared against the threshold, but if the resulting data set would be
larger than this setting, only the most relevant features up to the desired
feature set size are selected.

The default value is \code{NULL}, which causes features to be filtered based on
their relevance only.}
    \item{\code{low_var_minimum_variance_threshold}}{(required, if used) Numeric value
that determines which features will be filtered by the \code{low_variance}
method. The variance of each feature is computed and compared to the
threshold. If it is below the threshold, the feature is removed.

This parameter has no default value and should be set if \code{low_variance} is
used.}
    \item{\code{low_var_max_feature_set_size}}{(\emph{optional}) Maximum size of the feature
set after filtering features with a low variance. All features are first
compared against \code{low_var_minimum_variance_threshold}. If the resulting
feature set would be larger than specified, only the most strongly varying
features will be selected, up to the desired size of the feature set.

The default value is \code{NULL}, which causes features to be filtered based on
their variance only.}
    \item{\code{robustness_icc_type}}{(\emph{optional}) String indicating the type of
intraclass correlation coefficient (\code{1}, \code{2} or \code{3}) that should be used to
compute robustness for features in repeated measurements. These types
correspond to the types in Shrout and Fleiss (1979). The default value is
\code{1}.}
    \item{\code{robustness_threshold_metric}}{(\emph{optional}) String indicating which
specific intraclass correlation coefficient (ICC) metric should be used to
filter features. This should be one of:
\itemize{
\item \code{icc}: The estimated ICC value itself.
\item \code{icc_low} (default): The estimated lower limit of the 95\% confidence
interval of the ICC, as suggested by Koo and Li (2016).
\item \code{icc_panel}: The estimated ICC value over the panel average, i.e. the ICC
that would be obtained if all repeated measurements were averaged.
\item \code{icc_panel_low}: The estimated lower limit of the 95\% confidence interval
of the panel ICC.
}}
    \item{\code{robustness_threshold_value}}{(\emph{optional}) The intraclass correlation
coefficient value that is as threshold. The default value is \code{0.70}.}
    \item{\code{transformation_method}}{(\emph{optional}) The transformation method used to
change the distribution of the data to be more normal-like. The following
methods are available:
\itemize{
\item \code{none}: This disables transformation of features.
\item \code{yeo_johnson} (default): Transformation using the Yeo-Johnson
transformation (Yeo and Johnson, 2000). The algorithm tests various lambda
values (-2.0, -1.0, -0.5, 0.0, 0.33333, 0.5, 1.0, 1.5, 2.0) and selects the
lambda that maximises the log-likelihood.
\item \code{yeo_johnson_trim}: As \code{yeo_johnson}, but based on the set of feature
values where the 5\% lowest and 5\% highest values are discarded. This
reduces the effect of outliers.
\item \code{yeo_johnson_winsor}: As \code{yeo_johnson}, but based on the set of feature
values where the 5\% lowest and 5\% highest values are winsorised. This
reduces the effect of outliers.
\item \code{box_cox}: Transformation using the Box-Cox transformation (Box and Cox,
1964). Unlike the Yeo-Johnson transformation, the Box-Cox transformation
requires that all data are positive. Features that contain zero or negative
values cannot be transformed using this transformation. The algorithm tests
various lambda values (-2.0, -1.0, -0.5, 0.0, 0.3333, 0.5, 1.0, 1.5, 2.0)
and selects the lambda that maximises the log-likelihood.
\item \code{box_cox_trim}: As \code{box_cox}, but based on the set of feature values
where the 5\% lowest and 5\% highest values are discarded. This reduces the
effect of outliers.
\item \code{box_cox_winsor}: As \code{box_cox}, but based on the set of feature values
where the 5\% lowest and 5\% highest values are winsorised. This reduces the
effect of outliers.
}

Only features that contain numerical data are transformed. Transformation
parameters obtained in development data are stored within \code{featureInfo}
objects for later use with validation data sets.}
    \item{\code{normalisation_method}}{(\emph{optional}) The normalisation method used to
improve the comparability between numerical features that may have very
different scales. The following normalisation methods can be chosen:
\itemize{
\item \code{none}: This disables feature normalisation.
\item \code{standardisation} (default): Features are normalised by subtraction of
their mean values and division by their standard deviations. This causes
every feature to be have a center value of 0.0 and standard deviation of
1.0.
\item \code{standardisation_trim}: As \code{standardisation}, but based on the set of
feature values where the 5\% lowest and 5\% highest values are discarded.
This reduces the effect of outliers.
\item \code{standardisation_winsor}: As \code{standardisation}, but based on the set of
feature values where the 5\% lowest and 5\% highest values are winsorised.
This reduces the effect of outliers.
\item \code{normalisation}: Features are normalised by subtraction of their minimum
values and division by their ranges. This maps all feature values to a
\eqn{[0, 1]} interval.
\item \code{normalisation_trim}: As \code{normalisation}, but based on the set of feature
values where the 5\% lowest and 5\% highest values are discarded. This
reduces the effect of outliers.
\item \code{normalisation_winsor}: As \code{normalisation}, but based on the set of
feature values where the 5\% lowest and 5\% highest values are winsorised.
This reduces the effect of outliers.
\item \code{quantile}: Features are normalised by subtraction of their median values
and division by their interquartile range.
\item \code{mean_centering}: Features are centered by substracting the mean, but do
not undergo rescaling.
}

Only features that contain numerical data are normalised. Normalisation
parameters obtained in development data are stored within \code{featureInfo}
objects for later use with validation data sets.}
    \item{\code{batch_normalisation_method}}{(\emph{optional}) The method used for batch
normalisation. Available methods are:
\itemize{
\item \code{none} (default): This disables batch normalisation of features.
\item \code{standardisation}: Features within each batch are normalised by
subtraction of the mean value and division by the standard deviation in
each batch.
\item \code{standardisation_trim}: As \code{standardisation}, but based on the set of
feature values where the 5\% lowest and 5\% highest values are discarded.
This reduces the effect of outliers.
\item \code{standardisation_winsor}: As \code{standardisation}, but based on the set of
feature values where the 5\% lowest and 5\% highest values are winsorised.
This reduces the effect of outliers.
\item \code{normalisation}: Features within each batch are normalised by subtraction
of their minimum values and division by their range in each batch. This
maps all feature values in each batch to a \eqn{[0, 1]} interval.
\item \code{normalisation_trim}: As \code{normalisation}, but based on the set of feature
values where the 5\% lowest and 5\% highest values are discarded. This
reduces the effect of outliers.
\item \code{normalisation_winsor}: As \code{normalisation}, but based on the set of
feature values where the 5\% lowest and 5\% highest values are winsorised.
This reduces the effect of outliers.
\item \code{quantile}: Features in each batch are normalised by subtraction of the
median value and division by the interquartile range of each batch.
\item \code{mean_centering}: Features in each batch are centered on 0.0 by
substracting the mean value in each batch, but are not rescaled.
\item \code{combat_parametric}: Batch adjustments using parametric empirical Bayes
(Johnson et al, 2007). \code{combat_p} leads to the same method.
\item \code{combat_non_parametric}: Batch adjustments using non-parametric empirical
Bayes (Johnson et al, 2007). \code{combat_np} and \code{combat} lead to the same
method. Note that we reduced complexity from O(\eqn{n^2}) to O(\eqn{n}) by
only computing batch adjustment parameters for each feature on a subset of
50 randomly selected features, instead of all features.
}

Only features that contain numerical data are normalised using batch
normalisation. Batch normalisation parameters obtained in development data
are stored within \code{featureInfo} objects for later use with validation data
sets, in case the validation data is from the same batch.

If validation data contains data from unknown batches, normalisation
parameters are separately determined for these batches.

Note that for both empirical Bayes methods, the batch effect is assumed to
produce results across the features. This is often true for things such as
gene expressions, but the assumption may not hold generally.

When performing batch normalisation, it is moreover important to check that
differences between batches or cohorts are not related to the studied
endpoint.}
    \item{\code{imputation_method}}{(\emph{optional}) Method used for imputing missing
feature values. Two methods are implemented:
\itemize{
\item \code{simple}: Simple replacement of a missing value by the median value (for
numeric features) or the modal value (for categorical features).
\item \code{lasso}: Imputation of missing value by lasso regression (using \code{glmnet})
based on information contained in other features.
}

\code{simple} imputation precedes \code{lasso} imputation to ensure that any missing
values in predictors required for \code{lasso} regression are resolved. The
\code{lasso} estimate is then used to replace the missing value.

The default value depends on the number of features in the dataset. If the
number is lower than 100, \code{lasso} is used by default, and \code{simple}
otherwise.

Only single imputation is performed. Imputation models and parameters are
stored within \code{featureInfo} objects for later use with validation data
sets.}
    \item{\code{cluster_method}}{(\emph{optional}) Clustering is performed to identify and
replace redundant features, for example those that are highly correlated.
Such features do not carry much additional information and may be removed
or replaced instead (Park et al., 2007; Tolosi and Lengauer, 2011).

The cluster method determines the algorithm used to form the clusters. The
following cluster methods are implemented:
\itemize{
\item \code{none}: No clustering is performed.
\item \code{hclust} (default): Hierarchical agglomerative clustering. If the
\code{fastcluster} package is installed, \code{fastcluster::hclust} is used (Muellner
2013), otherwise \code{stats::hclust} is used.
\item \code{agnes}: Hierarchical clustering using agglomerative nesting (Kaufman and
Rousseeuw, 1990). This algorithm is similar to \code{hclust}, but uses the
\code{cluster::agnes} implementation.
\item \code{diana}: Divisive analysis hierarchical clustering. This method uses
divisive instead of agglomerative clustering (Kaufman and Rousseeuw, 1990).
\code{cluster::diana} is used.
\item \code{pam}: Partioning around medioids. This partitions the data into $k$
clusters around medioids (Kaufman and Rousseeuw, 1990). $k$ is selected
using the \code{silhouette} metric. \code{pam} is implemented using the
\code{cluster::pam} function.
}

Clusters and cluster information is stored within \code{featureInfo} objects for
later use with validation data sets. This enables reproduction of the same
clusters as formed in the development data set.}
    \item{\code{cluster_linkage_method}}{(\emph{optional}) Linkage method used for
agglomerative clustering in \code{hclust} and \code{agnes}. The following linkage
methods can be used:
\itemize{
\item \code{average} (default): Average linkage.
\item \code{single}: Single linkage.
\item \code{complete}: Complete linkage.
\item \code{weighted}: Weighted linkage, also known as McQuitty linkage.
\item \code{ward}: Linkage using Ward's minimum variance method.
}

\code{diana} and \code{pam} do not require a linkage method.}
    \item{\code{cluster_cut_method}}{(\emph{optional}) The method used to define the actual
clusters. The following methods can be used:
\itemize{
\item \code{silhouette}: Clusters are formed based on the silhouette score
(Rousseeuw, 1987). The average silhouette score is computed from 2 to
\eqn{n} clusters, with \eqn{n} the number of features. Clusters are only
formed if the average silhouette exceeds 0.50, which indicates reasonable
evidence for structure. This procedure may be slow if the number of
features is large (>100s).
\item \code{fixed_cut}: Clusters are formed by cutting the hierarchical tree at the
point indicated by the \code{cluster_similarity_threshold}, e.g. where features
in a cluster have an average Spearman correlation of 0.90. \code{fixed_cut} is
only available for \code{agnes}, \code{diana} and \code{hclust}.
\item \code{dynamic_cut}: Dynamic cluster formation using the cutting algorithm in
the \code{dynamicTreeCut} package. This package should be installed to select
this option. \code{dynamic_cut} can only be used with \code{agnes} and \code{hclust}.
}

The default options are \code{silhouette} for partioning around medioids (\code{pam})
and \code{fixed_cut} otherwise.}
    \item{\code{cluster_similarity_metric}}{(\emph{optional}) Clusters are formed based on
feature similarity. All features are compared in a pair-wise fashion to
compute similarity, for example correlation. The resulting similarity grid
is converted into a distance matrix that is subsequently used for
clustering. The following metrics are supported to compute pairwise
similarities:
\itemize{
\item \code{mcfadden_r2} (default): McFadden's pseudo R-squared (McFadden, 1974).
\item \code{cox_snell_r2}: Cox and Snell's pseudo R-squared (Cox and Snell, 1989).
\item \code{nagelkerke_r2}: Nagelkerke's pseudo R-squared (Nagelkerke, 1991).
\item \code{spearman}: Spearman's rank order correlation.
\item \code{kendall}: Kendall rank correlation.
\item \code{pearson}: Pearson product-moment correlation.
}

The pseudo R-squared metrics can be used to assess similarity between mixed
pairs of numeric and categorical features, as these are based on the
log-likelihood of regression models. In \code{familiar}, the more informative
feature is used as the predictor and the other feature as the reponse
variable. In numeric-categorical pairs, the numeric feature is considered
to be more informative and is thus used as the predictor. In
categorical-categorical pairs, the feature with most levels is used as the
predictor.

In case any of the classical correlation coefficients (\code{pearson},
\code{spearman} and \code{kendall}) are used with (mixed) categorical features, the
categorical features are one-hot encoded and the mean correlation over all
resulting pairs is used as similarity.}
    \item{\code{cluster_similarity_threshold}}{(\emph{optional}) The threshold level for
pair-wise similarity that is required to form clusters using \code{fixed_cut}.
This should be a numerical value between 0.0 and 1.0. Note however, that a
reasonable threshold value depends strongly on the similarity metric. The
following are the default values used:
\itemize{
\item \code{mcfadden_r2}: \code{0.30}
\item \code{cox_snell_r2} and \code{nagelkerke_r2}: \code{0.75}
\item \code{spearman}, \code{kendall} and \code{pearson}: \code{0.90}
}

Alternatively, if the \verb{fixed cut} method is not used, this value determines
whether any clustering should be performed, because the data may not
contain highly similar features. The default values in this situation are:
\itemize{
\item \code{mcfadden_r2}: \code{0.05}
\item \code{cox_snell_r2} and \code{nagelkerke_r2}: \code{0.40}
\item \code{spearman}, \code{kendall} and \code{pearson}: \code{0.50}
}

The threshold value is converted to a distance (1-similarity) prior to
cutting hierarchical trees.}
    \item{\code{cluster_representation_method}}{(\emph{optional}) Method used to determine
how the information of co-clustered features is summarised and used to
represent the cluster. The following methods can be selected:
\itemize{
\item \code{best_predictor} (default): The feature with the highest importance
according to univariate regression with the outcome is used to represent
the cluster.
\item \code{medioid}: The feature closest to the cluster center, i.e. the feature
that is most similar to the remaining features in the cluster, is used to
represent the feature.
\item \code{mean}: A meta-feature is generated by averaging the feature values for
all features in a cluster. This method aligns all features so that all
features will be positively correlated prior to averaging. Should a cluster
contain one or more categorical features, the \code{medioid} method will be used
instead, as averaging is not possible. Note that if this method is chosen,
the \code{normalisation_method} parameter should be one of \code{standardisation},
\code{standardisation_trim}, \code{standardisation_winsor} or \code{quantile}.`
}

If the \code{pam} cluster method is selected, only the \code{medioid} method can be
used. In that case 1 medioid is used by default.}
    \item{\code{parallel_preprocessing}}{(\emph{optional}) Enable parallel processing for the
preprocessing workflow. Defaults to \code{TRUE}. When set to \code{FALSE}, this will
disable the use of parallel processing while preprocessing, regardless of
the settings of the \code{parallel} parameter. \code{parallel_preprocessing} is
ignored if \code{parallel=FALSE}.}
    \item{\code{fs_method}}{(\strong{required}) Feature selection method to be used for
determining variable importance. \code{familiar} implements various feature
selection methods. Please refer to the vignette on feature selection
methods for more details.

More than one feature selection method can be chosen. The experiment will
then repeated for each feature selection method.

Feature selection methods determines the ranking of features. Actual
selection of features is done by optimising the signature size model
hyperparameter during the hyperparameter optimisation step.}
    \item{\code{fs_method_parameter}}{(\emph{optional}) List of lists containing parameters
for feature selection methods. Each sublist should have the name of the
feature selection method it corresponds to.

Most feature selection methods do not have parameters that can be set.
Please refer to the vignette on feature selection methods for more details.
Note that if the feature selection method is based on a learner (e.g. lasso
regression), hyperparameter optimisation may be performed prior to
assessing variable importance.}
    \item{\code{vimp_aggregation_method}}{(\emph{optional}) The method used to aggregate
variable importances over different data subsets, e.g. bootstraps. The
following methods can be selected:
\itemize{
\item \code{none}: Don't aggregate ranks, but rather aggregate the variable
importance scores themselves.
\item \code{mean}: Use the mean rank of a feature over the subsets to
determine the aggregated feature rank.
\item \code{median}: Use the median rank of a feature over the subsets to determine
the aggregated feature rank.
\item \code{best}: Use the best rank the feature obtained in any subset to determine
the aggregated feature rank.
\item \code{worst}: Use the worst rank the feature obtained in any subset to
determine the aggregated feature rank.
\item \code{stability}: Use the frequency of the feature being in the subset of
highly ranked features as measure for the aggregated feature rank
(Meinshausen and Buehlmann, 2010).
\item \code{exponential}: Use a rank-weighted frequence of occurrence in the subset
of highly ranked features as measure for the aggregated feature rank (Haury
et al., 2011).
\item \code{borda} (default): Use the borda count as measure for the aggregated
feature rank (Wald et al., 2012).
\item \code{enhanced_borda}: Use an occurrence frequency-weighted borda count as
measure for the aggregated feature rank (Wald et al., 2012).
\item \code{truncated_borda}: Use borda count computed only on features within the
subset of highly ranked features.
\item \code{enhanced_truncated_borda}: Apply both the enhanced borda method and the
truncated borda method and use the resulting borda count as the aggregated
feature rank.
}

The \emph{feature selection methods} vignette provides additional information.}
    \item{\code{vimp_aggregation_rank_threshold}}{(\emph{optional}) The threshold used to
define the subset of highly important features. If not set, this threshold
is determined by maximising the variance in the occurrence value over all
features over the subset size.

This parameter is only relevant for \code{stability}, \code{exponential},
\code{enhanced_borda}, \code{truncated_borda} and \code{enhanced_truncated_borda} methods.}
    \item{\code{parallel_feature_selection}}{(\emph{optional}) Enable parallel processing for
the feature selection workflow. Defaults to \code{TRUE}. When set to \code{FALSE},
this will disable the use of parallel processing while performing feature
selection, regardless of the settings of the \code{parallel} parameter.
\code{parallel_feature_selection} is ignored if \code{parallel=FALSE}.}
    \item{\code{learner}}{(\strong{required}) One or more algorithms used for model
development. A sizeable number learners is supported in \code{familiar}. Please
see the vignette on learners for more information concerning the available
learners.}
    \item{\code{hyperparameter}}{(\emph{optional}) List of lists containing hyperparameters
for learners. Each sublist should have the name of the learner method it
corresponds to, with list elements being named after the intended
hyperparameter, e.g. \code{"glm_logistic"=list("sign_size"=3)}

All learners have hyperparameters. Please refer to the vignette on learners
for more details. If no parameters are provided, sequential model-based
optimisation is used to determine optimal hyperparameters.

Hyperparameters provided by the user are never optimised. However, if more
than one value is provided for a single hyperparameter, optimisation will
be conducted using these values.}
    \item{\code{novelty_detector}}{(\emph{optional}) Specify the algorithm used for training
a novelty detector. This detector can be used to identify
out-of-distribution data prospectively.}
    \item{\code{detector_parameters}}{(\emph{optional}) List lists containing hyperparameters
for novelty detectors. Currently not used.}
    \item{\code{parallel_model_development}}{(\emph{optional}) Enable parallel processing for
the model development workflow. Defaults to \code{TRUE}. When set to \code{FALSE},
this will disable the use of parallel processing while developing models,
regardless of the settings of the \code{parallel} parameter.
\code{parallel_model_development} is ignored if \code{parallel=FALSE}.}
    \item{\code{optimisation_bootstraps}}{(\emph{optional}) Number of bootstraps that should
be generated from the development data set. During the optimisation
procedure one or more of these bootstraps (indicated by
\code{smbo_step_bootstraps}) are used for model development using different
combinations of hyperparameters. The effect of the hyperparameters is then
assessed by comparing in-bag and out-of-bag model performance.

The default number of bootstraps is \code{50}. Hyperparameter optimisation may
finish before exhausting the set of bootstraps.}
    \item{\code{optimisation_determine_vimp}}{(\emph{optional}) Logical value that indicates
whether variable importance is determined separately for each of the
bootstraps created during the optimisation process (\code{TRUE}) or the
applicable results from the feature selection step are used (\code{FALSE}).

Determining variable importance increases the initial computational
overhead. However, it prevents positive biases for the out-of-bag data due
to overlap of these data with the development data set used for the feature
selection step. In this case, any hyperparameters of the variable
importance method are not determined separately for each bootstrap, but
those obtained during the feature selection step are used instead. In case
multiple of such hyperparameter sets could be applicable, the set that will
be used is randomly selected for each bootstrap.

This parameter only affects hyperparameter optimisation of learners. The
default is \code{TRUE}.}
    \item{\code{smbo_random_initialisation}}{(\emph{optional}) String indicating the
initialisation method for the hyperparameter space. Can be one of
\code{fixed_subsample} (default), \code{fixed}, or \code{random}. \code{fixed} and
\code{fixed_subsample} first create hyperparameter sets from a range of default
values set by familiar. \code{fixed_subsample} then randomly draws up to
\code{smbo_n_random_sets} from the grid. \code{random} does not rely upon a fixed
grid, and randomly draws up to \code{smbo_n_random_sets} hyperparameter sets
from the hyperparameter space.}
    \item{\code{smbo_n_random_sets}}{(\emph{optional}) Number of random or subsampled
hyperparameters drawn during the initialisation process. Default: \code{100}.
Cannot be smaller than \code{10}. The parameter is not used when
\code{smbo_random_initialisation} is \code{fixed}, as the entire pre-defined grid
will be explored.}
    \item{\code{max_smbo_iterations}}{(\emph{optional}) Maximum number of intensify
iterations of the SMBO algorithm. During an intensify iteration a run-off
occurs between the current \emph{best} hyperparameter combination and either 10
challenger combination with the highest expected improvement or a set of 20
random combinations.

Run-off with random combinations is used to force exploration of the
hyperparameter space, and is performed every second intensify iteration, or
if there is no expected improvement for any challenger combination.

If a combination of hyperparameters leads to better performance on the same
data than the incumbent \emph{best} set of hyperparameters, it replaces the
incumbent set at the end of the intensify iteration.

The default number of intensify iteration is \code{20}. Iterations may be
stopped early if the incumbent set of hyperparameters remains the same for
\code{smbo_stop_convergent_iterations} iterations, or performance improvement is
minimal. This behaviour is suppressed during the first 4 iterations to
enable the algorithm to explore the hyperparameter space.}
    \item{\code{smbo_stop_convergent_iterations}}{(\emph{optional}) The number of subsequent
convergent SMBO iterations required to stop hyperparameter optimisation
early. An iteration is convergent if the \emph{best} parameter set has not
changed or the optimisation score over the 4 most recent iterations has not
changed beyond the tolerance level in \code{smbo_stop_tolerance}.

The default value is \code{3}.}
    \item{\code{smbo_stop_tolerance}}{(\emph{optional}) Tolerance for early stopping due to
convergent optimisation score.

The default value depends on the number of samples (at the series level),
ranging from \code{0.01} for 100 or fewer samples, to \code{0.001} for 10000 or more
samples.}
    \item{\code{smbo_time_limit}}{(\emph{optional}) Time limit (in minutes) for the
optimisation process. Optimisation is stopped after this limit is exceeded.
Time taken to determine variable importance for the optimisation process
(see the \code{optimisation_determine_vimp} parameter) does not count.

The default is \code{NULL}, indicating that there is no time limit for the
optimisation process. The time limit cannot be less than 1 minute.}
    \item{\code{smbo_step_bootstraps}}{(\emph{optional}) The number of bootstraps taken from
the set of \code{optimisation_bootstraps} bootstraps as data for the initial
SMBO step and the steps in each intensify iteration.

The default value is \code{3}. The value cannot be larger than
\code{optimisation_bootstraps}.}
    \item{\code{smbo_intensify_steps}}{(\emph{optional}) The number of steps in each SMBO
intensify iteration. Each step a new set of \code{smbo_step_bootstraps}
bootstraps is drawn and used in the run-off between the incumbent \emph{best}
hyperparameter combination and its challengers.

The default value is \code{5}. Higher numbers allow for a more detailed
comparison, but this comes with added computational cost.}
    \item{\code{optimisation_metric}}{(\emph{optional}) One or more metrics used to compute
performance scores. See the vignette on performance metrics for the
available metrics.

If unset, the following metrics are used by default:
\itemize{
\item \code{auc_roc}: For \code{binomial} and \code{multinomial} models.
\item \code{mse}: Mean squared error for \code{continuous} models.
\item \code{msle}: Mean squared logarithmic error for \code{count} models.
\item \code{concordance_index}: For \code{survival} models.
}

Multiple optimisation metrics can be specified. Actual metric values are
converted to an objective value by comparison with a baseline metric value
that derives from a trivial model, i.e. majority class for binomial and
multinomial outcomes, the median outcome for count and continuous outcomes
and a fixed risk or time for survival outcomes.}
    \item{\code{optimisation_function}}{(\emph{optional}) Type of optimisation function used
to quantify the performance of a hyperparameter set. Model performance is
assessed using the metric(s) specified by \code{optimisation_metric} on the
in-bag and out-of-bag samples of a bootstrap. These values are converted to
objective scores with a standardised interval of \eqn{[-1.0, 1.0]}, and are
referred to as \eqn{s'_{ib}} and \eqn{s'_{oob}}, respectively. The function
indicated by \code{optimisation_function} computes a objective score from each
pair of values:
\itemize{
\item \code{max_validation}: Uses the out-of-bag validation objective score
\eqn{s'_{oob}} as optimisation score. This function is widely used in
machine learning.
\item \code{balanced} (default): Computes \eqn{s'_{oob} - |s'_{oob} - s'_{ib}|}.
This function forces the algorithm to consider hyperparameter sets that
perform well on both development and validation data.
\item \code{stronger_balance}: Computes \eqn{s'_{oob} - 2.0 |s'_{oob} - s'_{ib}|}.
Stronger penalty than in the \code{balanced} objective.
}}
    \item{\code{hyperparameter_learner}}{(\emph{optional}) Any point in the hyperparameter
space has a single, scalar, optimisation score value that is \emph{a priori}
unknown. During the optimisation process, the algorithm samples from the
hyperparameter space by selecting hyperparameter sets and computing the
optimisation score value for one or more bootstraps. For each
hyperparameter set the resulting values are distributed around the actual
value. The learner indicated by \code{hyperparameter_learner} is then used to
infer optimisation score estimates for unsampled parts of the
hyperparameter space.

The following models are available:
\itemize{
\item \code{bayesian_additive_regression_trees} or \code{bart}: Uses Bayesian Additive
Regression Trees (Sparapani et al., 2021) for inference. Unlike standard
random forests, BART allows for estimating posterior distributions directly
and can extrapolate.
\item \code{gaussian_process} (default): Creates a localised approximate Gaussian
process for inference (Gramacy, 2016). This allows for better scaling than
deterministic Gaussian Processes.
\item \code{random_forest}: Creates a random forest for inference. Originally
suggested by Hutter et al. (2011). A weakness of random forests is their
lack of extrapolation beyond observed values, which limits their usefulness
in exploiting promising areas of hyperparameter space.
\item \code{random} or \code{random_search}: Forgoes the use of models to steer
optimisation. Instead, a random search is performed.
}}
    \item{\code{acquisition_function}}{(\emph{optional}) The acquisition function influences
how new hyperparameter sets are selected. The algorithm uses the model
learned by the learner indicated by \code{hyperparameter_learner} to search the
hyperparameter space for hyperparameter sets that are either likely better
than the best known set (\emph{exploitation}) or where there is considerable
uncertainty (\emph{exploration}). The acquisition function quantifies this
(Shahriari et al., 2016).

The following acquisition functions are available, and are described in
more detail in the \emph{learner algorithms} vignette:
\itemize{
\item \code{improvement_probability}: The probability of improvement quantifies the
probability that the expected optimisation score for a set is better than
the best observed optimisation score
\item \code{improvement_empirical_probability}: Similar to
\code{improvement_probability}, but based directly on optimisation scores
predicted by the individual decision trees.
\item \code{expected_improvement} (default): Computes expected improvement.
\item \code{upper_confidence_bound}: This acquisition function is based on the upper
confidence bound of the distribution (Srinivas et al., 2012).
\item \code{bayes_upper_confidence_bound}: This acquisition function is based on the
upper confidence bound of the distribution (Kaufmann et al., 2012).
}}
    \item{\code{exploration_method}}{(\emph{optional}) Method used to steer exploration in
post-initialisation intensive searching steps. As stated earlier, each SMBO
iteration step compares suggested alternative parameter sets with an
incumbent \strong{best} set in a series of steps. The exploration method
controls how the set of alternative parameter sets is pruned after each
step in an iteration. Can be one of the following:
\itemize{
\item \code{successive_halving} (default): The set of alternative parameter sets is
pruned by removing the worst performing half of the sets after each step
(Jamieson and Talwalkar, 2016).
\item \code{stochastic_reject}: The set of alternative parameter sets is pruned by
comparing the performance of each parameter set with that of the incumbent
\strong{best} parameter set using a paired Wilcoxon test based on shared
bootstraps. Parameter sets that perform significantly worse, at an alpha
level indicated by \code{smbo_stochastic_reject_p_value}, are pruned.
\item \code{none}: The set of alternative parameter sets is not pruned.
}}
    \item{\code{smbo_stochastic_reject_p_value}}{(\emph{optional}) The p-value threshold used
for the \code{stochastic_reject} exploration method.

The default value is \code{0.05}.}
    \item{\code{parallel_hyperparameter_optimisation}}{(\emph{optional}) Enable parallel
processing for hyperparameter optimisation. Defaults to \code{TRUE}. When set to
\code{FALSE}, this will disable the use of parallel processing while performing
optimisation, regardless of the settings of the \code{parallel} parameter. The
parameter moreover specifies whether parallelisation takes place within the
optimisation algorithm (\code{inner}, default), or in an outer loop ( \code{outer})
over learners, data subsamples, etc.

\code{parallel_hyperparameter_optimisation} is ignored if \code{parallel=FALSE}.}
    \item{\code{evaluate_top_level_only}}{(\emph{optional}) Flag that signals that only
evaluation at the most global experiment level is required. Consider a
cross-validation experiment with additional external validation. The global
experiment level consists of data that are used for development, internal
validation and external validation. The next lower experiment level are the
individual cross-validation iterations.

When the flag is \code{true}, evaluations take place on the global level only,
and no results are generated for the next lower experiment levels. In our
example, this means that results from individual cross-validation iterations
are not computed and shown. When the flag is \code{false}, results are computed
from both the global layer and the next lower level.

Setting the flag to \code{true} saves computation time.}
    \item{\code{skip_evaluation_elements}}{(\emph{optional}) Specifies which evaluation steps,
if any, should be skipped as part of the evaluation process. Defaults to
\code{none}, which means that all relevant evaluation steps are performed. It can
have one or more of the following values:
\itemize{
\item \code{none}, \code{false}: no steps are skipped.
\item \code{all}, \code{true}: all steps are skipped.
\item \code{auc_data}: data for assessing and plotting the area under the receiver
operating characteristic curve are not computed.
\item \code{calibration_data}: data for assessing and plotting model calibration are
not computed.
\item \code{calibration_info}: data required to assess calibration, such as baseline
survival curves, are not collected. These data will still be present in the
models.
\item \code{confusion_matrix}: data for assessing and plotting a confusion matrix are
not collected.
\item \code{decision_curve_analyis}: data for performing a decision curve analysis
are not computed.
\item \code{feature_expressions}: data for assessing and plotting sample clustering
are not computed.
\item \code{feature_similarity}: data for assessing and plotting feature clusters are
not computed.
\item \code{fs_vimp}: data for assessing and plotting feature selection-based
variable importance are not collected.
\item \code{hyperparameters}: data for assessing model hyperparameters are not
collected. These data will still be present in the models.
\item \code{ice_data}: data for individual conditional expectation and partial
dependence plots are not created.
\item \code{model_performance}: data for assessing and visualising model performance
are not created.
\item \code{model_vimp}: data for assessing and plotting model-based variable
importance are not collected.
\item \code{permutation_vimp}: data for assessing and plotting model-agnostic
permutation variable importance are not computed.
\item \code{prediction_data}: predictions for each sample are not made and exported.
\item \code{risk_stratification_data}: data for assessing and plotting Kaplan-Meier
survival curves are not collected.
\item \code{risk_stratification_info}: data for assessing stratification into risk
groups are not computed.
\item \code{univariate_analysis}: data for assessing and plotting univariate feature
importance are not computed.
}}
    \item{\code{ensemble_method}}{(\emph{optional}) Method for ensembling predictions from
models for the same sample. Available methods are:
\itemize{
\item \code{median} (default): Use the median of the predicted values as the ensemble
value for a sample.
\item \code{mean}: Use the mean of the predicted values as the ensemble value for a
sample.
}

This parameter is only used if \code{detail_level} is \code{ensemble}.}
    \item{\code{evaluation_metric}}{(\emph{optional}) One or more metrics for assessing model
performance. See the vignette on performance metrics for the available
metrics.

Confidence intervals (or rather credibility intervals) are computed for each
metric during evaluation. This is done using bootstraps, the number of which
depends on the value of \code{confidence_level} (Davison and Hinkley, 1997).

If unset, the metric in the \code{optimisation_metric} variable is used.}
    \item{\code{sample_limit}}{(\emph{optional}) Set the upper limit of the number of samples
that are used during evaluation steps. Cannot be less than 20.

This setting can be specified per data element by providing a parameter
value in a named list with data elements, e.g.
\code{list("sample_similarity"=100, "permutation_vimp"=1000)}.

This parameter can be set for the following data elements:
\code{sample_similarity} and \code{ice_data}.}
    \item{\code{detail_level}}{(\emph{optional}) Sets the level at which results are computed
and aggregated.
\itemize{
\item \code{ensemble}: Results are computed at the ensemble level, i.e. over all
models in the ensemble. This means that, for example, bias-corrected
estimates of model performance are assessed by creating (at least) 20
bootstraps and computing the model performance of the ensemble model for
each bootstrap.
\item \code{hybrid} (default): Results are computed at the level of models in an
ensemble. This means that, for example, bias-corrected estimates of model
performance are directly computed using the models in the ensemble. If there
are at least 20 trained models in the ensemble, performance is computed for
each model, in contrast to \code{ensemble} where performance is computed for the
ensemble of models. If there are less than 20 trained models in the
ensemble, bootstraps are created so that at least 20 point estimates can be
made.
\item \code{model}: Results are computed at the model level. This means that, for
example, bias-corrected estimates of model performance are assessed by
creating (at least) 20 bootstraps and computing the performance of the model
for each bootstrap.
}

Note that each level of detail has a different interpretation for bootstrap
confidence intervals. For \code{ensemble} and \code{model} these are the confidence
intervals for the ensemble and an individual model, respectively. That is,
the confidence interval describes the range where an estimate produced by a
respective ensemble or model trained on a repeat of the experiment may be
found with the probability of the confidence level. For \code{hybrid}, it
represents the range where any single model trained on a repeat of the
experiment may be found with the probability of the confidence level. By
definition, confidence intervals obtained using \code{hybrid} are at least as
wide as those for \code{ensemble}. \code{hybrid} offers the correct interpretation if
the goal of the analysis is to assess the result of a single, unspecified,
model.

\code{hybrid} is generally computationally less expensive then \code{ensemble}, which
in turn is somewhat less expensive than \code{model}.

A non-default \code{detail_level} parameter can be specified for separate
evaluation steps by providing a parameter value in a named list with data
elements, e.g. \code{list("auc_data"="ensemble", "model_performance"="hybrid")}.
This parameter can be set for the following data elements: \code{auc_data},
\code{decision_curve_analyis}, \code{model_performance}, \code{permutation_vimp},
\code{ice_data}, \code{prediction_data} and \code{confusion_matrix}.}
    \item{\code{estimation_type}}{(\emph{optional}) Sets the type of estimation that should be
possible. This has the following options:
\itemize{
\item \code{point}: Point estimates.
\item \code{bias_correction} or \code{bc}: Bias-corrected estimates. A bias-corrected
estimate is computed from (at least) 20 point estimates, and \code{familiar} may
bootstrap the data to create them.
\item \code{bootstrap_confidence_interval} or \code{bci} (default): Bias-corrected
estimates with bootstrap confidence intervals (Efron and Hastie, 2016). The
number of point estimates required depends on the \code{confidence_level}
parameter, and \code{familiar} may bootstrap the data to create them.
}

As with \code{detail_level}, a non-default \code{estimation_type} parameter can be
specified for separate evaluation steps by providing a parameter value in a
named list with data elements, e.g. \code{list("auc_data"="bci", "model_performance"="point")}. This parameter can be set for the following
data elements: \code{auc_data}, \code{decision_curve_analyis}, \code{model_performance},
\code{permutation_vimp}, \code{ice_data}, and \code{prediction_data}.}
    \item{\code{aggregate_results}}{(\emph{optional}) Flag that signifies whether results
should be aggregated during evaluation. If \code{estimation_type} is
\code{bias_correction} or \code{bc}, aggregation leads to a single bias-corrected
estimate. If \code{estimation_type} is \code{bootstrap_confidence_interval} or \code{bci},
aggregation leads to a single bias-corrected estimate with lower and upper
boundaries of the confidence interval. This has no effect if
\code{estimation_type} is \code{point}.

The default value is equal to \code{TRUE} except when assessing metrics to assess
model performance, as the default violin plot requires underlying data.

As with \code{detail_level} and \code{estimation_type}, a non-default
\code{aggregate_results} parameter can be specified for separate evaluation steps
by providing a parameter value in a named list with data elements, e.g.
\code{list("auc_data"=TRUE, , "model_performance"=FALSE)}. This parameter exists
for the same elements as \code{estimation_type}.}
    \item{\code{confidence_level}}{(\emph{optional}) Numeric value for the level at which
confidence intervals are determined. In the case bootstraps are used to
determine the confidence intervals bootstrap estimation, \code{familiar} uses the
rule of thumb \eqn{n = 20 / ci.level} to determine the number of required
bootstraps.

The default value is \code{0.95}.}
    \item{\code{bootstrap_ci_method}}{(\emph{optional}) Method used to determine bootstrap
confidence intervals (Efron and Hastie, 2016). The following methods are
implemented:
\itemize{
\item \code{percentile} (default): Confidence intervals obtained using the percentile
method.
\item \code{bc}: Bias-corrected confidence intervals.
}

Note that the standard method is not implemented because this method is
often not suitable due to non-normal distributions. The bias-corrected and
accelerated (BCa) method is not implemented yet.}
    \item{\code{feature_cluster_method}}{(\emph{optional}) Method used to perform clustering
of features. The same methods as for the \code{cluster_method} configuration
parameter are available: \code{none}, \code{hclust}, \code{agnes}, \code{diana} and \code{pam}.

The value for the \code{cluster_method} configuration parameter is used by
default. When generating clusters for the purpose of determining mutual
correlation and ordering feature expressions, \code{none} is ignored and \code{hclust}
is used instead.}
    \item{\code{feature_linkage_method}}{(\emph{optional}) Method used for agglomerative
clustering with \code{hclust} and \code{agnes}. Linkage determines how features are
sequentially combined into clusters based on distance. The methods are
shared with the \code{cluster_linkage_method} configuration parameter: \code{average},
\code{single}, \code{complete}, \code{weighted}, and \code{ward}.

The value for the \code{cluster_linkage_method} configuration parameters is used
by default.}
    \item{\code{feature_cluster_cut_method}}{(\emph{optional}) Method used to divide features
into separate clusters. The available methods are the same as for the
\code{cluster_cut_method} configuration parameter: \code{silhouette}, \code{fixed_cut} and
\code{dynamic_cut}.

\code{silhouette} is available for all cluster methods, but \code{fixed_cut} only
applies to methods that create hierarchical trees (\code{hclust}, \code{agnes} and
\code{diana}). \code{dynamic_cut} requires the \code{dynamicTreeCut} package and can only
be used with \code{agnes} and \code{hclust}.

The value for the \code{cluster_cut_method} configuration parameter is used by
default.}
    \item{\code{feature_similarity_metric}}{(\emph{optional}) Metric to determine pairwise
similarity between features. Similarity is computed in the same manner as
for clustering, and \code{feature_similarity_metric} therefore has the same
options as \code{cluster_similarity_metric}: \code{mcfadden_r2}, \code{cox_snell_r2},
\code{nagelkerke_r2}, \code{spearman}, \code{kendall} and \code{pearson}.

The value used for the \code{cluster_similarity_metric} configuration parameter
is used by default.}
    \item{\code{feature_similarity_threshold}}{(\emph{optional}) The threshold level for
pair-wise similarity that is required to form feature clusters with the
\code{fixed_cut} method. This threshold functions in the same manner as the one
defined using the \code{cluster_similarity_threshold} parameter.

By default, the value for the \code{cluster_similarity_threshold} configuration
parameter is used.

Unlike for \code{cluster_similarity_threshold}, more than one value can be
supplied here.}
    \item{\code{sample_cluster_method}}{(\emph{optional}) The method used to perform
clustering based on distance between samples. These are the same methods as
for the \code{cluster_method} configuration parameter: \code{hclust}, \code{agnes}, \code{diana}
and \code{pam}.

The value for the \code{cluster_method} configuration parameter is used by
default. When generating clusters for the purpose of ordering samples in
feature expressions, \code{none} is ignored and \code{hclust} is used instead.}
    \item{\code{sample_linkage_method}}{(\emph{optional}) The method used for agglomerative
clustering in \code{hclust} and \code{agnes}. These are the same methods as for the
\code{cluster_linkage_method} configuration parameter: \code{average}, \code{single},
\code{complete}, \code{weighted}, and \code{ward}.

The value for the \code{cluster_linkage_method} configuration parameters is used
by default.}
    \item{\code{sample_similarity_metric}}{(\emph{optional}) Metric to determine pairwise
similarity between samples. Similarity is computed in the same manner as for
clustering, but \code{sample_similarity_metric} has different options that are
better suited to computing distance between samples instead of between
features. The following metrics are available.
\itemize{
\item \code{gower} (default): compute Gower's distance between samples. By default,
Gower's distance is computed based on winsorised data to reduce the effect
of outliers (see below).
\item \code{euclidean}: compute the Euclidean distance between samples.
}

The underlying feature data for numerical features is scaled to the
\eqn{[0,1]} range using the feature values across the samples. The
normalisation parameters required can optionally be computed from feature
data with the outer 5\% (on both sides) of feature values trimmed or
winsorised. To do so append \verb{_trim} (trimming) or \verb{_winsor} (winsorising) to
the metric name. This reduces the effect of outliers somewhat.

Regardless of metric, all categorical features are handled as for the
Gower's distance: distance is 0 if the values in a pair of samples match,
and 1 if they do not.}
    \item{\code{eval_aggregation_method}}{(\emph{optional}) Method for aggregating variable
importances for the purpose of evaluation. Variable importances are
determined during feature selection steps and after training the model. Both
types are evaluated, but feature selection variable importance is only
evaluated at run-time.

See the documentation for the \code{vimp_aggregation_method} argument for
information concerning the different methods available.}
    \item{\code{eval_aggregation_rank_threshold}}{(\emph{optional}) The threshold used to
define the subset of highly important features during evaluation.

See the documentation for the \code{vimp_aggregation_rank_threshold} argument for
more information.}
    \item{\code{eval_icc_type}}{(\emph{optional}) String indicating the type of intraclass
correlation coefficient (\code{1}, \code{2} or \code{3}) that should be used to compute
robustness for features in repeated measurements during the evaluation of
univariate importance. These types correspond to the types in Shrout and
Fleiss (1979). The default value is \code{1}.}
    \item{\code{stratification_method}}{(\emph{optional}) Method for determining the
stratification threshold for creating survival groups. The actual,
model-dependent, threshold value is obtained from the development data, and
can afterwards be used to perform stratification on validation data.

The following stratification methods are available:
\itemize{
\item \code{median} (default): The median predicted value in the development cohort
is used to stratify the samples into two risk groups. For predicted outcome
values that build a continuous spectrum, the two risk groups in the
development cohort will be roughly equal in size.
\item \code{mean}: The mean predicted value in the development cohort is used to
stratify the samples into two risk groups.
\item \code{mean_trim}: As \code{mean}, but based on the set of predicted values
where the 5\% lowest and 5\% highest values are discarded. This reduces the
effect of outliers.
\item \code{mean_winsor}: As \code{mean}, but based on the set of predicted values where
the 5\% lowest and 5\% highest values are winsorised. This reduces the effect
of outliers.
\item \code{fixed}: Samples are stratified based on the sample quantiles of the
predicted values. These quantiles are defined using the
\code{stratification_threshold} parameter.
\item \code{optimised}: Use maximally selected rank statistics to determine the
optimal threshold (Lausen and Schumacher, 1992; Hothorn et al., 2003) to
stratify samples into two optimally separated risk groups.
}

One or more stratification methods can be selected simultaneously.

This parameter is only relevant for \code{survival} outcomes.}
    \item{\code{stratification_threshold}}{(\emph{optional}) Numeric value(s) signifying the
sample quantiles for stratification using the \code{fixed} method. The number of
risk groups will be the number of values +1.

The default value is \code{c(1/3, 2/3)}, which will yield two thresholds that
divide samples into three equally sized groups. If \code{fixed} is not among the
selected stratification methods, this parameter is ignored.

This parameter is only relevant for \code{survival} outcomes.}
    \item{\code{time_max}}{(\emph{optional}) Time point which is used as the benchmark for
e.g. cumulative risks generated by random forest, or the cutoff for Uno's
concordance index.

If \code{time_max} is not provided, but \code{evaluation_times} is, the largest value
of \code{evaluation_times} is used. If both are not provided, \code{time_max} is set
to the 98th percentile of the distribution of survival times for samples
with an event in the development data set.

This parameter is only relevant for \code{survival} outcomes.}
    \item{\code{evaluation_times}}{(\emph{optional}) One or more time points that are used for
assessing calibration in survival problems. This is done as expected and
observed survival probabilities depend on time.

If unset, \code{evaluation_times} will be equal to \code{time_max}.

This parameter is only relevant for \code{survival} outcomes.}
    \item{\code{dynamic_model_loading}}{(\emph{optional}) Enables dynamic loading of models
during the evaluation process, if \code{TRUE}. Defaults to \code{FALSE}. Dynamic
loading of models may reduce the overall memory footprint, at the cost of
increased disk or network IO. Models can only be dynamically loaded if they
are found at an accessible disk or network location. Setting this parameter
to \code{TRUE} may help if parallel processing causes out-of-memory issues during
evaluation.}
    \item{\code{parallel_evaluation}}{(\emph{optional}) Enable parallel processing for
hyperparameter optimisation. Defaults to \code{TRUE}. When set to \code{FALSE}, this
will disable the use of parallel processing while performing optimisation,
regardless of the settings of the \code{parallel} parameter. The parameter
moreover specifies whether parallelisation takes place within the evaluation
process steps (\code{inner}, default), or in an outer loop ( \code{outer}) over
learners, data subsamples, etc.

\code{parallel_evaluation} is ignored if \code{parallel=FALSE}.}
  }}
}
\value{
Nothing. All output is written to the experiment directory. If the
experiment directory is in a temporary location, a list with all
familiarModel, familiarEnsemble, familiarData and familiarCollection
objects will be returned.
}
\description{
Perform end-to-end machine learning and data analysis
}
\references{
\enumerate{
\item Storey, J. D. A direct approach to false discovery rates. J.
R. Stat. Soc. Series B Stat. Methodol. 64, 479–498 (2002).
\item Shrout, P. E. & Fleiss, J. L. Intraclass correlations: uses in assessing
rater reliability. Psychol. Bull. 86, 420–428 (1979).
\item Koo, T. K. & Li, M. Y. A guideline of selecting and reporting intraclass
correlation coefficients for reliability research. J. Chiropr. Med. 15,
155–163 (2016).
\item Yeo, I. & Johnson, R. A. A new family of power transformations to
improve normality or symmetry. Biometrika 87, 954–959 (2000).
\item Box, G. E. P. & Cox, D. R. An analysis of transformations. J. R. Stat.
Soc. Series B Stat. Methodol. 26, 211–252 (1964).
\item Park, M. Y., Hastie, T. & Tibshirani, R. Averaged gene expressions for
regression. Biostatistics 8, 212–227 (2007).
\item Tolosi, L. & Lengauer, T. Classification with correlated features:
unreliability of feature ranking and solutions. Bioinformatics 27,
1986–1994 (2011).
\item Johnson, W. E., Li, C. & Rabinovic, A. Adjusting batch effects in
microarray expression data using empirical Bayes methods. Biostatistics 8,
118–127 (2007)
\item Kaufman, L. & Rousseeuw, P. J. Finding groups in data: an introduction
to cluster analysis. (John Wiley & Sons, 2009).
\item Muellner, D. fastcluster: fast hierarchical, agglomerative clustering
routines for R and Python. J. Stat. Softw. 53, 1–18 (2013).
\item Rousseeuw, P. J. Silhouettes: A graphical aid to the interpretation and
validation of cluster analysis. J. Comput. Appl. Math. 20, 53–65 (1987).
\item Langfelder, P., Zhang, B. & Horvath, S. Defining clusters from a
hierarchical cluster tree: the Dynamic Tree Cut package for R.
Bioinformatics 24, 719–720 (2008).
\item McFadden, D. Conditional logit analysis of qualitative choice behavior.
in Frontiers in Econometrics (ed. Zarembka, P.) 105–142 (Academic Press,
1974).
\item Cox, D. R. & Snell, E. J. Analysis of binary data. (Chapman and Hall,
1989).
\item Nagelkerke, N. J. D. A note on a general definition of the coefficient
of determination. Biometrika 78, 691–692 (1991).
\item Meinshausen, N. & Buehlmann, P. Stability selection. J. R. Stat. Soc.
Series B Stat. Methodol. 72, 417–473 (2010).
\item Haury, A.-C., Gestraud, P. & Vert, J.-P. The influence of feature
selection methods on accuracy, stability and interpretability of molecular
signatures. PLoS One 6, e28210 (2011).
\item Wald, R., Khoshgoftaar, T. M., Dittman, D., Awada, W. & Napolitano,A. An
extensive comparison of feature ranking aggregation techniques in
bioinformatics. in 2012 IEEE 13th International Conference on Information
Reuse Integration (IRI) 377–384 (2012).
\item Hutter, F., Hoos, H. H. & Leyton-Brown, K. Sequential model-based
optimization for general algorithm configuration. in Learning and
Intelligent Optimization (ed. Coello, C. A. C.) 6683, 507–523 (Springer
Berlin Heidelberg, 2011).
\item Shahriari, B., Swersky, K., Wang, Z., Adams, R. P. & de Freitas, N.
Taking the Human Out of the Loop: A Review of Bayesian Optimization. Proc.
IEEE 104, 148–175 (2016)
\item Srinivas, N., Krause, A., Kakade, S. M. & Seeger, M. W.
Information-Theoretic Regret Bounds for Gaussian Process Optimization in
the Bandit Setting. IEEE Trans. Inf. Theory 58, 3250–3265 (2012)
\item Kaufmann, E., Cappé, O. & Garivier, A. On Bayesian upper confidence
bounds for bandit problems. in Artificial intelligence and statistics
592–600 (2012).
\item Jamieson, K. & Talwalkar, A. Non-stochastic Best Arm Identification and
Hyperparameter Optimization. in Proceedings of the 19th International
Conference on Artificial Intelligence and Statistics (eds. Gretton, A. &
Robert, C. C.) vol. 51 240–248 (PMLR, 2016).
\item Gramacy, R. B. laGP: Large-Scale Spatial Modeling via Local Approximate
Gaussian Processes in R. Journal of Statistical Software 72, 1–46 (2016)
\item Sparapani, R., Spanbauer, C. & McCulloch, R. Nonparametric Machine
Learning and Efficient Computation with Bayesian Additive Regression Trees:
The BART R Package. Journal of Statistical Software 97, 1–66 (2021)
\item Davison, A. C. & Hinkley, D. V. Bootstrap methods and their application.
(Cambridge University Press, 1997).
\item Efron, B. & Hastie, T. Computer Age Statistical Inference. (Cambridge
University Press, 2016).
\item Lausen, B. & Schumacher, M. Maximally Selected Rank Statistics.
Biometrics 48, 73 (1992).
\item Hothorn, T. & Lausen, B. On the exact distribution of maximally selected
rank statistics. Comput. Stat. Data Anal. 43, 121–137 (2003).
}
}
