% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{get_pkg_archive_path}
\alias{get_pkg_archive_path}
\title{Get a Package's Archive Path From the Package's DESCRIPTION}
\usage{
get_pkg_archive_path(path = ".", absolute = TRUE)
}
\arguments{
\item{path}{Path to the package.}

\item{absolute}{Return the absolute path?}
}
\value{
Path to the package's archive file.
}
\description{
Get a Package's Archive Path From the Package's DESCRIPTION
}
\note{
The archive file does not have to exist. Use
\code{file.exists(get_pkg_archive_path())} to test existence.
}
\examples{
package_path <- file.path(tempdir(), "anRpackage")
devtools::create(path = package_path)
print(tarball <- get_pkg_archive_path(package_path))
file.exists(tarball)
}
