% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_structure.R
\name{BlockStructure}
\alias{BlockStructure}
\title{Block structure}
\usage{
BlockStructure(pk)
}
\arguments{
\item{pk}{vector encoding the grouping structure.}
}
\value{
A symmetric matrix of size \code{length(pk))}.
}
\description{
Generates a symmetric matrix of size (\code{length(pk)} x \code{length(pk)})
where entries correspond to block indices. This function can be used to
visualise block indices of a matrix generated with \code{\link{BlockMatrix}}.
}
\examples{
# Example 1
BlockMatrix(pk = c(2, 3))
BlockStructure(pk = c(2, 3))

# Example 2
BlockMatrix(pk = c(2, 3, 2))
BlockStructure(pk = c(2, 3, 2))
}
\seealso{
Other block matrix functions: 
\code{\link{BlockDiagonal}()},
\code{\link{BlockMatrix}()}
}
\concept{block matrix functions}
