% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{SimulatePrecision}
\alias{SimulatePrecision}
\title{Simulation of precision matrix}
\usage{
SimulatePrecision(
  pk = NULL,
  theta,
  v_within = c(0.5, 1),
  v_between = c(0, 0.1),
  v_sign = c(-1, 1),
  continuous = TRUE,
  pd_strategy = "diagonally_dominant",
  ev_xx = NULL,
  scale = TRUE,
  u_list = c(1e-10, 1),
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{pk}{vector of the number of variables per group in the simulated data.
The number of nodes in the simulated graph is \code{sum(pk)}. With multiple
groups, the simulated (partial) correlation matrix has a block structure,
where blocks arise from the integration of the \code{length(pk)} groups.
This argument is only used if \code{sum(pk)} is equal to the number of
rows/columns in \code{theta} is not provided.}

\item{theta}{binary and symmetric adjacency matrix encoding the conditional
independence structure.}

\item{v_within}{vector defining the (range of) nonzero entries in the
diagonal blocks of the precision matrix. These values must be between -1
and 1 if \code{pd_strategy="min_eigenvalue"}. If \code{continuous=FALSE},
\code{v_within} is the set of possible precision values. If
\code{continuous=TRUE}, \code{v_within} is the range of possible precision
values.}

\item{v_between}{vector defining the (range of) nonzero entries in the
off-diagonal blocks of the precision matrix. This argument is the same as
\code{v_within} but for off-diagonal blocks. It is only used if
\code{length(pk)>1}.}

\item{v_sign}{vector of possible signs for precision matrix entries. Possible
inputs are: \code{-1} for positive partial correlations, \code{1} for
negative partial correlations, or \code{c(-1, 1)} for both positive and
negative partial correlations.}

\item{continuous}{logical indicating whether to sample precision values from
a uniform distribution between the minimum and maximum values in
\code{v_within} (diagonal blocks) or \code{v_between} (off-diagonal blocks)
(\code{continuous=TRUE}) or from proposed values in \code{v_within}
(diagonal blocks) or \code{v_between} (off-diagonal blocks)
(\code{continuous=FALSE}).}

\item{pd_strategy}{method to ensure that the generated precision matrix is
positive definite (and hence can be a covariance matrix). If
\code{pd_strategy="diagonally_dominant"}, the precision matrix is made
diagonally dominant by setting the diagonal entries to the sum of absolute
values on the corresponding row and a constant u. If
\code{pd_strategy="min_eigenvalue"}, diagonal entries are set to the sum of
the absolute value of the smallest eigenvalue of the precision matrix with
zeros on the diagonal and a constant u.}

\item{ev_xx}{expected proportion of explained variance by the first Principal
Component (PC1) of a Principal Component Analysis. This is the largest
eigenvalue of the correlation (if \code{scale_ev=TRUE}) or covariance (if
\code{scale_ev=FALSE}) matrix divided by the sum of eigenvalues. If
\code{ev_xx=NULL} (the default), the constant u is chosen by maximising the
contrast of the correlation matrix.}

\item{scale}{logical indicating if the proportion of explained variance by
PC1 should be computed from the correlation (\code{scale=TRUE}) or
covariance (\code{scale=FALSE}) matrix.}

\item{u_list}{vector with two numeric values defining the range of values to
explore for constant u.}

\item{tol}{accuracy for the search of parameter u as defined in
\code{\link[stats]{optimise}}.}
}
\value{
A list with: \item{omega}{true simulated precision matrix.}
  \item{u}{value of the constant u used to ensure that \code{omega} is
  positive definite.}
}
\description{
Simulates a sparse precision matrix from a binary adjacency matrix
\code{theta} encoding conditional independence in a Gaussian Graphical Model.
}
\details{
Entries that are equal to zero in the adjacency matrix \code{theta}
  are also equal to zero in the generated precision matrix. These zero
  entries indicate conditional independence between the corresponding pair of
  variables (see \code{\link{SimulateGraphical}}).

  Argument \code{pk} can be specified to create groups of variables and allow
  for nonzero precision entries to be sampled from different distributions
  between two variables belonging to the same group or to different groups.

  If \code{continuous=FALSE}, nonzero off-diagonal entries of the precision
  matrix are sampled from a discrete uniform distribution taking values in
  \code{v_within} (for entries in the diagonal block) or \code{v_between}
  (for entries in off-diagonal blocks). If \code{continuous=TRUE}, nonzero
  off-diagonal entries are sampled from a continuous uniform distribution
  taking values in the range given by \code{v_within} or \code{v_between}.

  Diagonal entries of the precision matrix are defined to ensure positive
  definiteness as described in \code{\link{MakePositiveDefinite}}.
}
\examples{
# Simulation of an adjacency matrix
theta <- SimulateAdjacency(pk = c(5, 5), nu_within = 0.7)
print(theta)

# Simulation of a precision matrix maximising the contrast
simul <- SimulatePrecision(theta = theta)
print(simul$omega)

# Simulation of a precision matrix with specific ev by PC1
simul <- SimulatePrecision(
  theta = theta,
  pd_strategy = "min_eigenvalue",
  ev_xx = 0.3, scale = TRUE
)
print(simul$omega)
}
\references{
\insertRef{ourstabilityselection}{fake}
}
\seealso{
\code{\link{SimulateGraphical}}, \code{\link{MakePositiveDefinite}}
}
