% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_group_metric.R
\name{plot.group_metric}
\alias{plot.group_metric}
\title{Plot group metric}
\usage{
\method{plot}{group_metric}(x, ...)
}
\arguments{
\item{x}{object of class group_metric}

\item{...}{other group_metric objects and other parameters}
}
\value{
list of \code{ggplot2} objects
}
\description{
Plot chosen metric in group. Notice how models are treating different subgroups.
Compare models both in fairness metrics and in performance. Parity loss can be enabled when creating \code{group_metric} object.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) - 1

lm_model <- glm(Risk ~ .,
  data = german,
  family = binomial(link = "logit")
)


explainer_lm <- DALEX::explain(lm_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_lm,
  protected = german$Sex,
  privileged = "male"
)

gm <- group_metric(fobject, "TPR", "f1", parity_loss = TRUE)
plot(gm)
\donttest{

rf_model <- ranger::ranger(Risk ~ .,
  data = german,
  probability = TRUE,
  num.trees = 200
)

explainer_rf <- DALEX::explain(rf_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_rf, fobject)

gm <- group_metric(fobject, "TPR", "f1", parity_loss = TRUE)

plot(gm)
}

}
