% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelPerformance.R
\name{get_all_metrics}
\alias{get_all_metrics}
\title{Calculate the all metrics at once}
\usage{
get_all_metrics(data, outcome, group, probs, cutoff = 0.5, digits = 2)
}
\arguments{
\item{data}{Data frame containing the outcome, predicted outcome, and
sensitive attribute}

\item{outcome}{the name of the outcome variable, it must be binary}

\item{group}{the name of the sensitive attribute}

\item{probs}{the name of the predicted outcome variable}

\item{cutoff}{the threshold for the predicted outcome, default is 0.5}

\item{digits}{the number of digits to round the result to, default is 2}
}
\value{
a Data frame of all metrics
}
\description{
This function computes a comprehensive set of fairness-related performance metrics across the
levels of a sensitive attribute. It includes standard classification metrics (e.g., TPR, FPR, PPV, NPV)
as well as fairness-specific indicators like predicted positive rates and error ratios.
}
\details{
This is useful for quickly assessing multiple fairness dimensions of a binary classifier in one step.
}
\examples{
\donttest{
library(fairmetrics)
library(dplyr)
library(magrittr)
library(randomForest)
data("mimic_preprocessed")
set.seed(123)
train_data <- mimic_preprocessed \%>\%
  dplyr::filter(dplyr::row_number() <= 700)
# Fit a random forest model
rf_model <- randomForest::randomForest(factor(day_28_flg) ~ ., data = train_data, ntree = 1000)
# Test the model on the remaining data
test_data <- mimic_preprocessed \%>\%
  dplyr::mutate(gender = ifelse(gender_num == 1, "Male", "Female"))\%>\%
  dplyr::filter(dplyr::row_number() > 700)

test_data$pred <- predict(rf_model, newdata = test_data, type = "prob")[, 2]

# Fairness evaluation
# We will use sex as the sensitive attribute and day_28_flg as the outcome.
# We choose threshold = 0.41 so that the overall FPR is around 5\%.

# Calculate All Metrics
get_all_metrics(
  dat = test_data,
  outcome = "day_28_flg",
  group = "gender",
  probs = "pred",
  cutoff = 0.41
)
}
}
