% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/V2ColumnOrganizedStachUtilities.R
\docType{class}
\name{V2ColumnOrganizedStachUtilities}
\alias{V2ColumnOrganizedStachUtilities}
\title{V2ColumnOrganizedStachUtilities}
\description{
Provide helper functions for column organized stach
}
\examples{
\dontrun{
compressedFilePath <- 'Path of your json file'
compressedData <- jsonlite::read_json(path=compressedFilePath,
auto_unbox=TRUE)
stachUtilities <-
factset.protobuf.stachextensions::V2ColumnOrganizedStachUtilities
primaryTableIds <-
stachUtilities$public_methods$GetPrimaryTableIds(compressedData)
}

\dontrun{
compressedFilePath <- 'Path of your json file'
compressedData <- jsonlite::read_json(path=compressedFilePath,
auto_unbox=TRUE)
utility <-
factset.protobuf.stachextensions::V2ColumnOrganizedStachUtilities$new()
deCompressedData <- utility$Decompress(compressedData)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GetPrimaryTableIds}{\code{V2ColumnOrganizedStachUtilities$GetPrimaryTableIds()}}
\item \href{#method-Decompress}{\code{V2ColumnOrganizedStachUtilities$Decompress()}}
\item \href{#method-clone}{\code{V2ColumnOrganizedStachUtilities$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetPrimaryTableIds"></a>}}
\if{latex}{\out{\hypertarget{method-GetPrimaryTableIds}{}}}
\subsection{Method \code{GetPrimaryTableIds()}}{
Get Primary Table Ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{V2ColumnOrganizedStachUtilities$GetPrimaryTableIds(package)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{package}}{Stach Data which is represented as a Package object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns list of primary table ids
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Decompress"></a>}}
\if{latex}{\out{\hypertarget{method-Decompress}{}}}
\subsection{Method \code{Decompress()}}{
Get decompress stach data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{V2ColumnOrganizedStachUtilities$Decompress(package)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{package}}{Stach Data which is represented as a Package object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns decompressed stach data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{V2ColumnOrganizedStachUtilities$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
