% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_statistics_api.R
\docType{class}
\name{ColumnStatisticsApi}
\alias{ColumnStatisticsApi}
\title{ColumnStatistics operations}
\format{An \code{R6Class} generator object}
\description{
factset.analyticsapi.engines.ColumnStatistics
}
\section{Methods}{

\describe{
\strong{ GetPAColumnStatistics } \emph{ Get PA column statistics }
This endpoint lists all the column statistics that can be applied to a PA column.

\itemize{
\item \emph{ @returnType } named list( \link{ColumnStatistic} ) \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | Expected response, returns a list of PA column statistics

\item return type : map(ColumnStatistic) 
\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 401 | Missing or invalid authentication.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 403 | User is forbidden with current credentials


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 503 | Request timed out. Retry the request in sometime.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
}

}
}

\examples{
\dontrun{
####################  GetPAColumnStatistics  ####################

library(factset.analyticsapi.engines)

#Get PA column statistics
api.instance <- ColumnStatisticsApi$new()

#Configure HTTP basic authorization: Basic
# provide your username in the user-serial format
api.instance$apiClient$username <- '<user-serial>'; 
# provide your api key generated using the developer portal
api.instance$apiClient$password <- '<api_key>';

result <- tryCatch(
            api.instance$GetPAColumnStatistics(),
            ApiException = function(ex) ex 
         )
# In case of error, print the error object 
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{apiClient}}{Handles the client-server communication.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ColumnStatisticsApi$new()}}
\item \href{#method-GetPAColumnStatistics}{\code{ColumnStatisticsApi$GetPAColumnStatistics()}}
\item \href{#method-GetPAColumnStatisticsWithHttpInfo}{\code{ColumnStatisticsApi$GetPAColumnStatisticsWithHttpInfo()}}
\item \href{#method-clone}{\code{ColumnStatisticsApi$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ColumnStatisticsApi$new(apiClient)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetPAColumnStatistics"></a>}}
\subsection{Method \code{GetPAColumnStatistics()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ColumnStatisticsApi$GetPAColumnStatistics(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetPAColumnStatisticsWithHttpInfo"></a>}}
\subsection{Method \code{GetPAColumnStatisticsWithHttpInfo()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ColumnStatisticsApi$GetPAColumnStatisticsWithHttpInfo(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ColumnStatisticsApi$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
