# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Configurations operations
#' @description factset.analyticsapi.engines.Configurations
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ GetVaultConfigurationById } \emph{ Get Vault configuration by id }
#' This endpoint returns details for a Vault configuration as well as a list of accounts it is used in.
#'
#' \itemize{
#' \item \emph{ @param } id character
#' \item \emph{ @returnType } \link{VaultConfiguration} \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns details for a Vault configuration.
#'
#' \item return type : VaultConfiguration 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid vault configuration code.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | Vault configuration id not found.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' \strong{ GetVaultConfigurations } \emph{ Get Vault configurations }
#' This endpoint returns all the Vault configurations saved in the provided account.
#'
#' \itemize{
#' \item \emph{ @param } account character
#' \item \emph{ @returnType } named list( \link{VaultConfigurationSummary} ) \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns a dictionary of Vault configurations.
#'
#' \item return type : map(VaultConfigurationSummary) 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid account.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | Account not found.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \dontrun{
#' ####################  GetVaultConfigurationById  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.id <- 'id_example' # character | Vault configuration id to get the details of
#'
#' #Get Vault configuration by id
#' api.instance <- ConfigurationsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetVaultConfigurationById(var.id),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' ####################  GetVaultConfigurations  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.account <- 'account_example' # character | Required account query parameter to filter configurations for a specific account
#'
#' #Get Vault configurations
#' api.instance <- ConfigurationsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetVaultConfigurations(var.account),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom caTools base64encode
#' @importFrom rlang abort
#' @export
ConfigurationsApi <- R6::R6Class(
  'ConfigurationsApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    GetVaultConfigurationById = function(id, ...){
      apiResponse <- self$GetVaultConfigurationByIdWithHttpInfo(id, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetVaultConfigurationByIdWithHttpInfo = function(id, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`id`)) {
        rlang::abort(message = "Missing required parameter `id`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `id`."))
      }

      urlPath <- "/analytics/lookups/v2/engines/vault/configurations/{id}"
      if (!missing(`id`)) {
        urlPath <- gsub(paste0("\\{", "id", "\\}"), URLencode(as.character(`id`), reserved = TRUE), urlPath)
      }

      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "VaultConfiguration", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    },
    GetVaultConfigurations = function(account, ...){
      apiResponse <- self$GetVaultConfigurationsWithHttpInfo(account, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetVaultConfigurationsWithHttpInfo = function(account, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`account`)) {
        rlang::abort(message = "Missing required parameter `account`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `account`."))
      }

      queryParams['account'] <- account

      urlPath <- "/analytics/lookups/v2/engines/vault/configurations"
      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "map(VaultConfigurationSummary)", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    }
  )
)
