% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FacebookCommentsCollection.R
\name{FacebookCommentsCollection}
\alias{FacebookCommentsCollection}
\title{Build a collection of Facebook comments to posts}
\usage{
FacebookCommentsCollection(id, token = NULL, parameters = list(),
  fields = c("id", "from.fields(id,name)", "message", "created_time"),
  n = getOption("facebook.maxitems"), metadata = FALSE,
  .progress = create_progress_bar())
}
\arguments{
\item{id}{A character vector or a comma-delimited string of IDs or an existing Facebook Collection of any 
of the supported types (see below).}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{\link{fbOAuth}}. If token \code{NULL} and \code{id} is a collection,
use the token of the source collection. Otherwise, no query is performed
to the Facebook Graph API and an empty collection is returned.}

\item{parameters}{A list of parameters to be added to the Facebook Graph API query. For more information on the
accepted parameters, see: \url{https://developers.facebook.com/docs/graph-api/using-graph-api}.}

\item{fields}{A character vector with the fields to get for each \code{id}. If no value
for a given field is found, it will be set to \code{NULL}.}

\item{n}{If \code{id} is an iterable collection, then \code{n} is the maximum number of comments to be pulled for each element of the source collection
in \code{id}. It can be set to \code{Inf} to pull out any available comment and assumes the default value from the value
of \code{facebook.maxitems} global option if missing. If \code{id} is not a collection or cannot be iterated, the parameter is ignored.}

\item{metadata}{If set to \code{TRUE}, the metadata for each ID is pulled with the data
and the \code{type} slot is fed accordingly.
Please note that setting this to \code{TRUE} could considerably
slow down the execution time, as more queries are needed.}

\item{.progress}{progress_bar object as defined in the plyr package.
By default the \code{none} progress bar is used, which prints nothing to the console. See \link[plyr]{create_progress_bar} for details.}
}
\value{
A collection of comments in a \code{\link{FacebookCommentsCollection-class}} object.
}
\description{
Connect to Facebook Graph API, get information from a list of Facebook comments to posts and build a \code{FacebookPostsCollection-class}
instance.
}
\details{
\code{FacebookCommentsCollection} is the constructor for the \code{\link{FacebookCommentsCollection-class}}.
It returns data about comments but doesn't return lists of their own comments or likes,
although it \strong{does} return an approximate total count for both (depending on the privacy settings of the users).
}
\section{Nesting fields}{

Due to the network-graph nature of Facebook data model,
you can specify fields details for each field nesting \code{.fields()} clauses.

For example, if you need only \code{id} and \code{source} for the \code{cover} field, this is valid among others:
\code{cover.fields(id,source)}.

Following the same philosophy, if you need only \code{id} and \code{name} for the \code{from} node
you can use \code{from.fields(id,name)}.
}

\section{Valid sources}{

Instead of a character vector, one of these collections can also be passed as parameter in \code{id}:
\itemize{
 \item{\code{\link{FacebookPostsCollection-class}} will build a collection with 
 the comments to the posts in the source collection.}
 \item{\code{\link{FacebookPhotosCollection-class}} will build a collection with 
 the comments to the photos in the source collection. The author of the photo may grant the
 \code{user_photos} to the current application to perform this action.}
 \item{\code{\link{FacebookVideosCollection-class}} will build a collection with 
 the comments to the videos in the source collection. The author of the photo may grant the
 \code{user_videos} to the current application to perform this action.}
 \item{\code{\link{FacebookCommentsCollection-class}} will build a collection with 
 the replies to the comments in the source collection.}
 \item{\code{\link{FacebookEventsCollection-class}} will build a collection with 
 the comments to the events in the source collection.}
}
}

\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
 load("fb_oauth")
 
## Getting information about two example Facebook Pages
 fb.pages <- FacebookPagesCollection(id = c("9thcirclegames", 
                                            "NathanNeverSergioBonelliEditore"),
                                     token = fb_oauth)
 
## Pull the latest 10 posts from each page in a post collection
 fb.posts <- FacebookPostscollection(id = fb.pages, token = fb_oauth, n = 10)
 
## Pull all the available posts from each page in a post collection
 fb.posts.inf <- FacebookPostscollection(id = fb.pages, token = fb_oauth, n = Inf)

## Pull all the available comments from each post of the first collection
 fb.comments.inf <- FacebookPostscollection(id = fb.posts, token = fb_oauth)
   
## Convert the collection to a data frame
fb.comments <- as.data.frame(fb.comments)

# The same as before in a more compact fashion using the pipe operator
# chaining first from a pages and then a posts collection
fb.comments.pipe <- 
 FacebookPagesCollection(id = c("9thcirclegames", 
                                "NathanNeverSergioBonelliEditore"),
                         token = fb_oauth) \%>\% 
   FacebookPostscollection(n = 10) \%>\% 
   FacebookCommentsCollection(n = Inf)
}

}
\seealso{
\code{\link{FacebookLikesCollection}}, \code{\link{FacebookPostsCollection}}, \code{\link{fbOAuth}}

Other Facebook Collection Constructors: \code{\link{FacebookAlbumsCollection}},
  \code{\link{FacebookConversationsCollection}},
  \code{\link{FacebookEventsCollection}},
  \code{\link{FacebookGroupsCollection}},
  \code{\link{FacebookLikesCollection}},
  \code{\link{FacebookMessagesCollection}},
  \code{\link{FacebookPagesCollection}},
  \code{\link{FacebookPhotosCollection}},
  \code{\link{FacebookPostsCollection}},
  \code{\link{FacebookReactionsCollection}},
  \code{\link{FacebookUsersCollection}},
  \code{\link{FacebookVideosCollection}}
}
\author{
Gabriele Baldassarre \url{https://gabrielebaldassarre.com}
}
