% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_image_add.R
\name{fabric_image_add}
\alias{fabric_image_add}
\title{Add an image to a preexisting canvas element}
\usage{
fabric_image_add(
  cid,
  imgId,
  imgsrc,
  imgwidth = 500,
  imgheight = 500,
  left = 100,
  top = 100,
  angle = 0,
  opacity = 1,
  strokecolor = "darkblue",
  strokewidth = 1,
  selectable = TRUE
)
}
\arguments{
\item{cid}{the id of the canvas element you want to add your image to}

\item{imgId}{the of the image}

\item{imgsrc}{the URL source of the image}

\item{imgwidth}{the width of the image. Defaults to 500}

\item{imgheight}{the height of the image. Defaults to 500}

\item{left}{the image's position from the left relative to the canvas element. Defaults to 100}

\item{top}{the image's position from the top relative to the canvas element. Defaults to 100}

\item{angle}{the angle of rotation of the image. Defaults to 0 (no rotation)}

\item{opacity}{the opacity of the image (from 0 to 1). Defaults to 1}

\item{strokecolor}{the stroke color of the image. Defaults to 'darkblue'}

\item{strokewidth}{the stroke width of the image. Defaults to 1}

\item{selectable}{logical. If TRUE, the user can modify interactively the image's size, position and rotation. Defaults to TRUE}
}
\value{
an image inside a preexisting canvas element
}
\description{
Add an image to a preexisting canvas element
}
\examples{
if (interactive()) {

img1 <- "https://upload.wikimedia.org/wikipedia/commons/thumb/1/1b/R_logo.svg/724px-R_logo.svg.png"
img2 <- "https://raw.githubusercontent.com/rstudio/hex-stickers/master/PNG/dplyr.png"
ui <- fluidPage(

use_fabric(),



fabric_image(cid = "cimage",
             imgId = "Rimg",
             imgsrc = img1,
             imgheight = 200,
             imgwidth = 200),

fabric_image_add(cid = "cimage",
                 imgId = "rstudioimg",
                 imgsrc = img2,
                 imgwidth = 200,
                 imgheight = 200,
                 left = 400)
                 )

server <- function(input, output) {}

shinyApp(ui = ui, server = server)

}
}
