% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{residuals.TSLM}
\alias{residuals.TSLM}
\title{Extract residuals from a fable model}
\usage{
\method{residuals}{TSLM}(object, ...)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{...}{Other arguments passed to methods}
}
\value{
A vector of fitted residuals.
}
\description{
Extracts the residuals.
}
\examples{
as_tsibble(USAccDeaths) \%>\%
  model(lm = TSLM(log(value) ~ trend() + season())) \%>\%
  residuals()
}
