\name{fSeriesMills}

\alias{fSeriesMills}


\alias{RS} 	
\alias{R20} 	
\alias{RSQ} 	
\alias{R20Q} 	
\alias{RSQREAL} 	
\alias{FTAPRICE} 
\alias{FTADIV} 	
\alias{FTARET} 	
\alias{RPI} 	
\alias{EXCHD} 	
\alias{EXCHQ} 	
\alias{SP500} 	
\alias{SP500R} 	
\alias{SP500D} 	
\alias{FT30} 	
\alias{FTSE100} 	
\alias{CTLD} 	
\alias{LGEN} 	
\alias{PRU} 	
	 		

\title{Terence Mill's Data Sets}


\description{

	A collection of data sets from the book "The Econometric Modelling
	of Financial Time Series" written by Terence C. Mills.
	\cr
	
	The data sets are:
	
	\tabular{rll}{	
	 	 1	\tab	\code{RS.txt} 	
	 		\tab 	Monthly 91 day Treasury Bill rate, \cr
	 	 2	\tab	\code{R20.txt} 	
	 		\tab 	Monthly Yield on 20 Year UK Gilts, \cr
     	 3	\tab	\code{RSQ.txt} 	
     		\tab 	Quarterly 91 day Treasury Bill rate, \cr
     	 4	\tab	\code{R20Q.txt} 	
     		\tab 	Quarterly Yield on 20 Year UK Gilts, \cr
     	 5	\tab	\code{RSQREAL.txt} 	
     		\tab 	Quarterly real 91 day Treasury Bill rate, \cr
     	 6	\tab	\code{FTAPRICE.txt} 
     		\tab	FTA All Share Price Index, \cr
     	 7	\tab	\code{FTADIV.txt} 	
	 		\tab 	FTA All Share Dividend Index, \cr
	 	 8	\tab	\code{FTARET.txt} 	
	 		\tab 	FTA All Share Nominal Returns, \cr
	 	 9	\tab	\code{RPI.txt} 	
	 		\tab 	UK Retail Price Index, \cr
	 	10	\tab	\code{EXCHD.txt} 	
	 		\tab 	Dollar/Sterling Exchange Rate, \cr
	 	11	\tab	\code{EXCHQ.txt} 	
	 		\tab 	Dollar/Sterling Exchange Rate, \cr
	 	12	\tab	\code{SP500.txt} 	
	 		\tab 	SP 500 Annual Data Index, \cr
	 	13	\tab	\code{SP500R.txt} 	
	 		\tab 	SP 500 Real Returns, \cr
	 	14	\tab	\code{SP500D.txt} 	
	 		\tab 	SP 500 Daily Data Index, \cr
	 	15	\tab	\code{FT30.txt} 	
	 		\tab 	FT 30 Index, \cr
	 	16	\tab	\code{FTSE100.txt} 	
	 		\tab 	FTSE 100 Index, \cr
	 	17	\tab	\code{CTLD.txt} 	
	 		\tab 	Courtaulds Share Price, \cr
	 	18	\tab	\code{LGEN.txt} 	
	 		\tab 	Legal and General Share Price, \cr
	 	19	\tab	\code{PRU.txt} 	
	 		\tab 	Prudential Share Price. }
    
}


\details{
     		
    \bold{RS - 91 Day Treasury Bill Rate:}
    \cr\cr
    Monthly data values starting in March 1952 and ending December 1995. 
	The data set includes one column with 526 observations.
	\cr
		
	\bold{R20 - Yield on 20 Year UK Gilts:}
    \cr\cr
    Monthly data values starting in March 1952 and ending December 1995. 
	The data set includes one column with 526 observations.
	\cr
	
	\bold{RSQ - 91 day Treasury Bill Rate:}
    \cr\cr
    Quarterly data values starting in Q1 1952 and ending Q4 1995.
	The data set includes one column with 176 observations.
	\cr
	
	\bold{R20Q - Yield on 20 Year UK Gilts:}
    \cr\cr
    Quarterly data values starting in Q1 1952 and ending Q4 1995.
	The data set includes one column with 176 observations. 
	\cr
	
	\bold{RSQREAL - Real 91 day Treasury Bill Rate:}
    \cr\cr
    Quarterly data values starting in Q1 1952 and ending Q3 1995.
	The data set includes one column with 175 observations.
	\cr
	
	\bold{FTAPRICE - FTA All Share Price Index:}
    \cr\cr
    Monthly data values starting in January 1965 and ending December 1995. 
	The data set includes one column with 372 observations. 
	\cr
	
	\bold{FTADIV - FTA All Share Dividend Index:}
    \cr\cr
    Monthly data values starting in January 1965 and ending December 1995. 
	The data set includes one column with 372 observations.
	\cr
	
	\bold{FTARET - FTA All Share Nominal Returns:}
    \cr\cr
    Monthly data values starting in January 1965 and ending December 1995. 
	The data set includes one column with 372 observations.
	\cr
	
	\bold{RPI - UK Retail Price Index:}
    \cr\cr
    Monthly data values starting in January 1965 and ending December 1995. 
	The data set includes one column with 372 observations.
	\cr
	
	\bold{EXCHD - Dollar/Sterling Exchange Rate:}
    \cr\cr
    Daily data values ranging from 1974 to 1994 
	The data set includes one column with 5'192 observations.
	\cr
	
	\bold{EXCHQ - Dollar/Sterling Exchange Rate:}
    \cr\cr
    Quarterly data values starting in Q1 1972 and ending Q4 1996.
	The data set includes one column with 100 observations.
	\cr
	
	\bold{SP500 - SP 500 Index:}
    \cr\cr
    Annual data values ranging from 1871 to 1997. 
	The data set includes one column with 127 observations.
	\cr
	
	\bold{SP500R - SP 500 Real Returns:}
    \cr\cr
    Annual data values ranging from 1872 to 1995. 
	The data set includes one column with 124 observations.
	\cr
	
	\bold{SP500D - SP 500 Index:}
    \cr\cr
    Daily data values ranging from 1928 to 1991.
	The data set includes one column with 17'054 observations.
	\cr
	
	\bold{FT30 - FT 30 Index:}
    \cr\cr
    Daily data values ranging from 1935 to 1994. 
	The data set includes one column with 15'003 observations.
	\cr
	
	\bold{FTSE100 - FTSE 100 Index:}
    \cr\cr
    Weekly data values ranging from 1984 to 1993.
	The data set includes one column with 521 observations.
	\cr
	
	\bold{CTLD - Courtaulds Share Price:}
    \cr\cr
    Weekly data values ranging from 1984 to 1993.
	The data set includes one column with 521 observations.
	\cr
	
	\bold{LGEN - Legal and General Share Price:}
    \cr\cr
    Weekly data values ranging from 1984 to 1993.
	The data set includes one column with 521 observations.
	\cr
	
	\bold{PRU - Prudential Share Price:}
    \cr\cr
    Weekly data values ranging from 1984 to 1993.
	The data set includes one column with 521 observations.

}

\references{

Mills, T.C. (1999);
	\emph{The Econometric Modelling of Financial Time Series,}
	Second Edition, Cmbridge University Press.
	
}


\examples{
## RS.txt - 
   data(RS)
   plot(as.ts(RS))
}


\keyword{datasets}

