% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dct_convert}
\alias{dct_convert}
\alias{dct2Hz}
\alias{Hz2dct}
\title{Convert between number of DCT bases and Hz of highpass filter}
\usage{
dct_convert(T_, TR, n = NULL, f = NULL)

dct2Hz(T_, TR, n)

Hz2dct(T_, TR, f)
}
\arguments{
\item{T_}{Length of timeseries (number of timepoints)}

\item{TR}{TR of the fMRI scan, in seconds (the time between timepoints)}

\item{n}{Number of cosine bases}

\item{f}{Hz of highpass filter}
}
\value{
If \code{n} was provided, the highpass filter cutoff (Hz) is returned.
Otherwise, if \code{f} was provided, the number of cosine bases is returned.
The result should be rounded before passing to \code{\link{dct_bases}}
}
\description{
Provide either \code{n} or \code{f} to calculate the other.
}
\details{
If only the total length of the scan is known, you can set that to \code{TR}
and use \code{T_=1}.

\eqn{f = n / (2 * T_ * TR)}
}
