% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pscrub_multi.R
\name{pscrub_multi}
\alias{pscrub_multi}
\title{Compare projection scrubbing measures with \code{pscrub_multi}}
\usage{
pscrub_multi(
  X,
  projection = "ICA_kurt",
  nuisance = "DCT4",
  center = TRUE,
  scale = TRUE,
  comps_mean_dt = FALSE,
  comps_var_dt = FALSE,
  kurt_quantile = 0.99,
  get_dirs = FALSE,
  full_PCA = FALSE,
  get_outliers = TRUE,
  cutoff = 4,
  seed = 0,
  ICA_method = c("C", "R"),
  verbose = FALSE
)
}
\arguments{
\item{X}{Wide numeric data matrix (\eqn{T} observations by \eqn{V} variables,
\eqn{T << V}). If \code{X} represents an fMRI run, \eqn{T} should be the
number of timepoints and \eqn{V} should be the number of vertices/voxels.
Projection scrubbing will measure the outlyingness of each row in \code{X}.}

\item{projection}{Projection scrubbing projects the data onto directions
likely to contain outlier information. Choose at least one of the following:

\describe{
\item{\code{"PCA"}}{PCA using the top \eqn{k} PCs.}
\item{\code{"PCA_kurt"}}{PCA using the high-kurtosis PCs among the top \eqn{k}.}
\item{\code{"PCA2"}}{PCA using the top \eqn{k2} PCs.}
\item{\code{"PCA2_kurt"}}{PCA using the high-kurtosis PCs among the top \eqn{k2}.}
\item{\code{"ICA"}}{ICA using the top \eqn{k} ICs.}
\item{\code{"ICA_kurt"}}{ICA using the high-kurtosis ICs among the top \eqn{k}.}
\item{\code{"ICA2"}}{ICA using the top \eqn{k2} ICs.}
\item{\code{"ICA2_kurt"}}{ICA using the high-kurtosis ICs among the top \eqn{k2}.}
}

where \eqn{k} is the number of components determined by PESEL, and \eqn{k2}
is the number of principal components with above-average variance.

Use \code{"all"} to use all projection methods. Default: \code{"ICA_kurt"}.}

\item{nuisance}{Nuisance signals to regress from each column of \code{X}.
Should be specified as a design matrix: a \eqn{T} by \eqn{N} numeric matrix
where \eqn{N} represents the number of nuisance signals. Or can be "DCT4"
(default), which will create a matrix with a constant column (the intercept
term) and four DCT bases. This default nuisance regression will have the
effect of demeaning and detrending the data by removing low-frequency
components. To not perform any nuisance regression set this argument to
\code{NULL}, \code{0}, or \code{FALSE}.

Detrending is highly recommended for time-series data, especially if there
are many time points or evolving circumstances affecting the data. Additionally,
if kurtosis is being used to select the projection directions, trends can
induce positive or negative kurtosis, contaminating the connection between
high kurtosis and outlier presence. Detrending should not be used with
non-time-series data because the observations are not temporally related.

Additional nuisance regressors can be specified like so:
\code{cbind(1, fMRItools::dct_bases(nrow(x), 4), more_nuisance)}.}

\item{center, scale}{Center the columns of the data by their medians, and scale the
columns of the data by their median absolute deviations (MADs)? Default: \code{TRUE}.
Centering is necessary for computing the projections, so if \code{center} is
\code{FALSE}, the data must already be centered.

Note that centering and scaling occur after nuisance regression, so even if
\code{center} is \code{FALSE}, the data will be centered on the means if
the nuisance regression included an intercept term, as it does by default.}

\item{comps_mean_dt, comps_var_dt}{Stabilize the mean and variance of each
projection component's timecourse prior to computing kurtosis and leverage?
These arguments should be \code{TRUE}, \code{FALSE} (default), or the number
of DCT bases to use for detrending (\code{TRUE} will use 4).
Note that these arguments affect the projection components and not the data
itself. Also, if variance-stabilizing but not mean-stabilizing,
the components must already be expected to be mean-stabilized, for example
if the data was rigorously detrended; otherwise, the results will be invalid.

Slow-moving mean and variance patterns in the components will interfere with
the roles of kurtosis and leverage in identifying outliers. While
\code{nuisance} can be used to detrend the data, this nuisance regression is
estimated \emph{non-robustly}, since a robust model takes too long to estimate
at each data location. On the other hand, \code{comps_mean_dt} and
\code{comps_var_dt} can be used to apply a \emph{robust} nuisance regression at each
component, since there are much fewer components than original data locations.
Thus, even if the data has been detrended with \code{nuisance} it may be
helpful to detrend the components with \code{comps_mean_dt}; furthermore,
the data nuisance regression does not address the potential existence of variance
patterns in the components.

Overall, for fMRI we recommend enabling \code{comps_mean_dt} and \code{comps_var_dt}
unless the data has been cleaned not only with a low-pass filter like
DCT nuisance regression, but also with anatomical CompCor, ICA-FIX, or
a similar data-driven strategy that takes into account common sources of
artifactual mean and variance trends such as motion and physiological cycles.}

\item{kurt_quantile}{What quantile cutoff should be used to select the
components? Default: \code{0.99}. Use \code{0} to select all high-variance
components regardless of kurtosis value.

We model each component as a length \eqn{T} vector of Normal iid random variables,
for which the distribution of kurtosis values can be approximated. The
quantile is estimated based on this distribution.}

\item{get_dirs}{Should the projection directions be returned? This is the
\eqn{V} matrix in PCA and \eqn{S} matrix in ICA. The default is \code{FALSE}
to save memory. However, \code{get_dirs==TRUE} is required for \code{\link{artifact_images}}.}

\item{full_PCA}{Only applies to the PCA projection. Return the full SVD?
Default: \code{FALSE} (return only the high-variance components).}

\item{get_outliers}{Should outliers be flagged based on \code{cutoff}? Default: \code{TRUE}.}

\item{cutoff}{Median leverage cutoff value. Default: \code{4}.}

\item{seed}{Set a seed right before the call to \code{pesel::pesel} or
\code{ica::icaimax}? If \code{NULL}, do not set a seed. If numeric (default:
\code{0}), will use as the seed.}

\item{ICA_method}{The \code{method} argument to \code{fastICA}: \code{"C"} to
use C code with BLAS (default), or \code{"R"} to use R code.}

\item{verbose}{Should occasional updates be printed? Default: \code{FALSE}.}
}
\value{
A \code{"pscrub_multi"} object, i.e. a list with components
\describe{
\item{measure}{A \eqn{T} by \eqn{P} data.frame of numeric leverage values, each column being the leverage values for a projection method in \code{projection}.}
\item{measure_info}{A data.frame with \eqn{P} rows listing information about each projection used.}
\item{outlier_cutoff}{A \eqn{1} by \eqn{P} data.frame of numeric outlier cutoff values for each projection (\code{cutoff} times the median leverage).}
\item{outlier_flag}{A \eqn{T} by \eqn{P} data.frame of logical values where \code{TRUE} indicates where leverage exceeds the cutoff, signaling suspected outlier presence.}
\item{mask}{
A length \eqn{P} numeric vector corresponding to the data locations in \code{X}. Each value indicates whether the location was masked:
\describe{
\item{1}{The data location was not masked out.}
\item{-1}{The data location was masked out, because it had at least one \code{NA} or \code{NaN} value.}
\item{-2}{The data location was masked out, because it was constant.}
}
}
\item{PCA}{
This will be a list with components:
\describe{
\item{U}{The \eqn{T} by \eqn{Q} PC score matrix.}
\item{D}{The standard deviation of each PC.}
\item{V}{The \eqn{P} by \eqn{Q} PC directions matrix. Included only if \code{get_dirs}.}
\item{highkurt}{The length \code{Q} logical vector indicating scores of high kurtosis.}
\item{U_dt}{Detrended components of \code{U}. Included only if components were mean- or variance-detrended.}
\item{highkurt}{The length \code{Q} logical vector indicating detrended scores of high kurtosis.}
\item{nPCs_PESEL}{The number of PCs selected by PESEL.}
\item{nPCs_avgvar}{The number of above-average variance PCs.}
}
where \code{Q} is the number of PCs selected by PESEL or of above-average variance (or the greater of the two if both were used).
If PCA was not used, all entries except \code{nPCs_PESEL} and/or \code{nPCs_avgvar} will not be included, depending on which
method(s) was used to select the number of PCs.
}
\item{ICA}{
If ICA was used, this will be a list with components:
\describe{
\item{S}{The \eqn{P} by \eqn{Q} source signals matrix. Included only if \code{get_dirs}}
\item{M}{The \eqn{T} by \eqn{Q} mixing matrix.}
\item{highkurt}{The length \code{Q} logical vector indicating mixing scores of high kurtosis.}
\item{M_dt}{Detrended components of \code{M}. Included only if components were mean- or variance-detrended.}
\item{highkurt}{The length \code{Q} logical vector indicating detrended mixing scores of high kurtosis. Included only if components were mean- or variance-detrended.}
}
}
}
}
\description{
Calculates leverage to identify outliers in high-dimensional data.
Can get results using multiple kinds of projections.
}
\keyword{internal}
