% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_hmm.R
\name{simulate_observations}
\alias{simulate_observations}
\title{Simulate state-dependent observations}
\usage{
simulate_observations(
  markov_chain,
  sdd,
  mu,
  sigma = NULL,
  df = NULL,
  seed = NULL,
  total_length = length(markov_chain)
)
}
\arguments{
\item{markov_chain}{A \code{numeric} vector of states of a Markov chain.}

\item{sdd}{A \code{character}, the name of the state-dependent distribution.}

\item{mu}{A \code{numeric} vector of expected values.}

\item{sigma}{A \code{numeric} vector of standard deviations (if any).}

\item{df}{A \code{numeric} vector of degrees of freedom (if any).}

\item{seed}{Sets a seed for the observation sampling.}

\item{total_length}{An \code{integer}, the total length of the output vector.
Must be greater or equal than \code{length(markov_chain)}.}
}
\value{
A \code{numeric} vector of length \code{total_length}, where the first
\code{length(markov_chain)} elements are numeric values and the last
\code{total_length - length(markov_chain)} elements are \code{NA_real_}.
}
\description{
This function simulates state-dependent observations.
}
\keyword{internal}
