% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ezsummary_categorical.r
\name{ezsummary_categorical}
\alias{ezsummary_categorical}
\title{Easy summary for categorical data}
\usage{
ezsummary_categorical(tbl, n = FALSE, count = TRUE, p = TRUE, P = FALSE,
  round.N = 3, flavor = "long", unit_markup = NULL)
}
\arguments{
\item{tbl}{The input matrix of data you would like to analyze.}

\item{n}{n is a True/False switch that controls whether total counts(N) should be included in
the output.}

\item{count}{a T/F switch to control if counts should be included}

\item{p}{a T/F switch to control if proportion should be included}

\item{P}{a T/F switch to control if Percentage should be included. This will be a
character output}

\item{round.N}{Rounding number.}

\item{flavor}{Flavor has two possible inputs: "long" and "wide". "Long" is the default
setting which will put grouping information on the left side of the table. It is more
machine readable and is good to be passed into the next analytical stage if needed.
"Wide" is more print ready (except for column names, which you can fix in the next step,
or fix in LaTex or packages like \code{htmlTable}). In the "wide" mode, the analyzed
variable will be the only "ID" variable and all the stats values will be presented ogranized
by the grouping variables (if any). If there is no grouping, the outputs of "wide" and
"long" will be the same.}

\item{unit_markup}{When unit_markup is not NULL, it will call the ezmarkup function and
perform column combination here. To make everyone's life easier, I'm using the term "unit"
here. Each unit mean each group of statistical summary results. If you want to
know mean and stand deviation, these two values are your units so you can put something
like "[. (.)]" there}
}
\value{
This function will organize all the results into one dataframe. If there are
any group_by variables, the first few columns will be them. After these, the varible
x will be the one listing all the categorical options in a format like "variable_option".
The stats summaries are listed in the last few columns.
}
\description{
This function provided an easy-to-use way to display simple statistical
summary for categorical data. It can be used together with \code{\link[dplyr]{select}}
and \code{\link[dplyr]{group_by}}. If the piece of data passed into the function has
one/multiple group_by variables, the percentage and count will be calculated within
the defined groups.
}
\examples{
library(dplyr)
mtcars \%>\% group_by(am) \%>\% select(cyl, gear, carb) \%>\% ezsummary_categorical()
mtcars \%>\% select(cyl, gear, carb) \%>\% ezsummary_categorical(n=TRUE, round.N = 2)
}

