% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pie_plot.R
\name{pie_plot}
\alias{pie_plot}
\title{pie_plot}
\usage{
pie_plot(data, x, y = "1", facet_x = NULL, facet_y = NULL,
  labels_y = function(x) ez_labels(x * 100, append = "\%", round = round,
  signif = signif), size = 14, label_cutoff = 0.04, round = Inf,
  signif = 3, palette = ez_col, reorder = c("x", "facet_x",
  "facet_y"), label_x = 0.8)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{y}{A named character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{facet_y}{A character. Evaluates to a column.}

\item{labels_y}{label formatting function}

\item{size}{theme size for \code{use_theme()}. Default is 14.}

\item{label_cutoff}{Cutoff size (proportion of limit range) for excluding
labels}

\item{round}{Option for rounding label.}

\item{signif}{Option for retaining significant figures in label.}

\item{palette}{Colour function.}

\item{reorder}{A character vector specifying the group variables to reorder.
Default is \code{c("group", "facet_x", "facet_y")}.}

\item{label_x}{Position of label from centre of pie.  0 is the centre of the
pie and 1 is the outer edge.}
}
\value{
ggplot object
}
\description{
Creates pie charts.
}
\examples{
\donttest{
df = ez_data()
pie_plot(df, "fct", "units")
pie_plot(df, "fct", "units", reorder = NULL, label_x = 0.5)
pie_plot(df, "fct", "units", "year", reorder = NULL, label_x = 0.5)
pie_plot(df, "fct", "units", "year", "char")
pie_plot(df, "fct", "units", "year", "char", reorder = NULL)
}
}
