% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_plot.R
\name{mean_plot}
\alias{mean_plot}
\title{mean_plot}
\usage{
mean_plot(data, x, y, size = 14, labels = ez_labels)
}
\arguments{
\item{data}{data.frame}

\item{x}{quoted expression (required)}

\item{y}{quoted expression (required)}

\item{size}{base_size for ggplot2 theme (default is 20)}

\item{labels}{function for formatting labels (default is ez_labels)}
}
\description{
Chart to compare the means across groups using a bar chart.
}
\examples{
library(dplyr)
mean_plot(mtcars, c("Number of Cylinders" = "factor(cyl)"), "hp > 110",
          labels = function(x) ez_labels(100 * x, append = "\%"))
}
