% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_test.R
\name{setup_ezspin_test}
\alias{setup_ezknit_test}
\alias{setup_ezspin_test}
\alias{setup_test}
\title{Set up a test directory to experiment with \code{ezspin} or \code{ezknit}}
\usage{
setup_ezspin_test()

setup_ezknit_test()
}
\value{
The path to the test directory.
}
\description{
Create a few directories that try to mimic a real
data-analysis project structure, and add a data file and a simple R script
(for \code{ezspin}) or Rmarkdown file (for \code{ezknit}).\cr\cr
After setting up these files and directories, you can run \code{ezknitr}
commands and their equivalent \code{knitr} commands to compare and see the
benefits of using \code{ezknitr}.\cr\cr
More specific instructions on how to interact with this test directory will
be printed to the console.
}
\examples{
\dontrun{
library(ezknitr)

# setup the test directory structures and run naive spin
setup_ezspin_test()
knitr::spin("ezknitr_test/R/ezspin_test.R")
file.remove(c("ezspin_test.md", "ezspin_test.html"))

# setup the test directory structures and run simple ezspin
setup_ezspin_test()
ezspin("R/ezspin_test.R", wd = "ezknitr_test")

# setup the test directory structures and run ezspin with more parameters
tmp <- setup_ezspin_test()
ezspin("R/ezspin_test.R", wd = "ezknitr_test",
        out_dir = "output", fig_dir = "coolplots")
unlink(tmp, recursive = TRUE, force = TRUE)
}
}
\seealso{
\code{\link[ezknitr]{ezspin}}
\code{\link[knitr]{spin}}
\code{\link[ezknitr]{ezknit}}
\code{\link[knitr]{knit}}
\code{\link[ezknitr]{open_output_dir}}
}

