% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_forest.R
\name{show_forest}
\alias{show_forest}
\title{Show Forest Plot}
\usage{
show_forest(
  data,
  covariates,
  controls = NULL,
  time = "time",
  status = "status",
  merge_models = FALSE,
  model_names = NULL,
  vars_to_show = NULL,
  drop_controls = FALSE,
  add_caption = TRUE,
  point_size = 3,
  point_shape = 15,
  color = "red",
  banded = TRUE,
  headings = list(variable = "Variable", n = "N", measure = "Hazard ratio", ci = NULL,
    p = "p"),
  model_dir = file.path(tempdir(), "ezcox"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} containing variables, time and os status.}

\item{covariates}{a character vector optionally listing the variables to include in the plot (defaults to all variables).}

\item{controls}{column names specifying controls.}

\item{time}{column name specifying time, default is 'time'.}

\item{status}{column name specifying event status, default is 'status'.}

\item{merge_models}{if 'TRUE', merge all models and keep the plot tight.}

\item{model_names}{model names to show when \code{merge_models=TRUE}.}

\item{vars_to_show}{default is \code{NULL}, show all variables
(including controls). You can use this to choose variables
to show, but remember, the models have not been changed.}

\item{drop_controls}{works when \code{covariates=NULL} and \code{models} is a \code{ezcox_models}, if \code{TRUE},
it removes control variables automatically.}

\item{add_caption}{if \code{TRUE}, add caption to the plot.}

\item{point_size}{size of point.}

\item{point_shape}{shape value of point.}

\item{color}{color for point and segment.}

\item{banded}{if \code{TRUE} (default), create banded background color.}

\item{headings}{a \code{list} for setting the heading text.}

\item{model_dir}{a path for storing model results.}

\item{verbose}{if \code{TRUE}, print extra info.}

\item{...}{other arguments passing to \code{\link[forestmodel:forest_model]{forestmodel::forest_model()}}.}
}
\value{
a \code{ggplot} object
}
\description{
This is a wrapper of function \link{ezcox}, \link{get_models} and
\link{show_models}. It focus on generating forest plot easily
and flexibly.
}
\examples{
library(survival)
show_forest(lung, covariates = c("sex", "ph.ecog"), controls = "age")
show_forest(lung, covariates = c("sex", "ph.ecog"), controls = "age", merge_models = TRUE)
show_forest(lung,
  covariates = c("sex", "ph.ecog"), controls = "age", merge_models = TRUE,
  drop_controls = TRUE
)
show_forest(lung,
  covariates = c("sex", "ph.ecog"), controls = "age", merge_models = TRUE,
  vars_to_show = "sex"
)
}
