% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_AOI_growth.R
\name{plot_AOI_growth}
\alias{plot_AOI_growth}
\title{Plots absolute or proportional time spent in AOIs over time}
\usage{
plot_AOI_growth(
  data = NULL,
  AOIs = NULL,
  AOI_names = NULL,
  type = NULL,
  trial_number = NULL,
  plot_time_not_in_AOI = FALSE
)
}
\arguments{
\item{data}{raw data in standard raw data form (time, x, y, trial)}

\item{AOIs}{A dataframe of areas of interest (AOIs), with one row per AOI (x, y, width_radius, height)}

\item{AOI_names}{An optional vector of AOI names to replace the default "AOI_1", "AOI_2", etc. To omit AOIs from the plot, use NA in relevant vector position}

\item{type}{either "abs" (absolute) or "prop" (proportion)}

\item{trial_number}{can be used to select particular trials within the data}

\item{plot_time_not_in_AOI}{boolean as to whether to include proportion of time spent outside AOIs}
}
\value{
a plot of the raw data
}
\description{
A visualisation tool for plotting the changes in defined AOI regions across a single trial time.
}
\examples{

\donttest{
data <- combine_eyes(HCL)
data <- data[data$pNum == 118 & data$trial == 1,]
data <- interpolate(data)
# plot absolute and then proportional
plot_AOI_growth(data = data, AOIs = HCL_AOIs, type = "abs")
plot_AOI_growth(data = data, AOIs = HCL_AOIs, type = "prop")
}

}
