% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/va_cleaner.R
\name{clean_va}
\alias{clean_va}
\alias{convert_NLP}
\alias{isNAstring}
\title{Visual acuity entry cleaner}
\usage{
clean_va(x, quali = c("nlp", "lp", "hm", "cf"))

convert_NLP(x, replace_PL = c(pl = "lp", npl = "nlp"), tolower = TRUE)

isNAstring(
  x,
  full = c("\\\\.+", "", "\\\\s+", "n/a", "na", "null"),
  tolower = TRUE
)
}
\arguments{
\item{x}{Vector with VA entries}

\item{quali}{strings for qualitative visual acuity entries}

\item{replace_PL}{named vector how to rename qualitative VA}

\item{tolower}{if TRUE, x will be converted to lower first}

\item{full}{vector of full strings to be replaced by NA}
}
\value{
character vector
}
\description{
VA cleaning:
\enumerate{
\item \code{\link[=isNAstring]{isNAstring()}}:
Replacing empty placeholders (".","", "(any number of empty space)",
"NULL", "NA", "N/A" ) - any cases - with NA
\item \code{\link[=convert_NLP]{convert_NLP()}} Simplifying the notation for qualitative VA notation
(NPL becomes NLP, PL becomes LP)
\item Removing non-Snellen character strings
}
}
\seealso{
Other VA cleaner: 
\code{\link{va}()}

Other VA cleaner: 
\code{\link{va}()}
}
\concept{VA cleaner}
