% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{cox.adapt}
\alias{cox.adapt}
\title{Compute the extreme quantile procedure for Cox model}
\usage{
cox.adapt(
  X,
  cph,
  cens = rep(1, length(X)),
  data = rep(0, length(X)),
  initprop = 1/10,
  gridlen = 100,
  r1 = 1/4,
  r2 = 1/20,
  CritVal = 10
)
}
\arguments{
\item{X}{a numeric vector of data values.}

\item{cph}{an output object of the function coxph from the package survival.}

\item{cens}{a binary vector corresponding to the censored values.}

\item{data}{a data frame containing the covariates values.}

\item{initprop}{the initial proportion at which we begin to test the model.}

\item{gridlen}{the length of the grid for which the test is done.}

\item{r1}{a proportion value of the data from the right that we skip in the test statistic.}

\item{r2}{a proportion value of the data from the left that we skip in the test statistic.}

\item{CritVal}{the critical value assiociated to procedure.}
}
\value{
\item{coefficients}{the coefficients of the coxph procedure.}
\item{Xsort}{the sorted vector of the data.}
\item{sortcens}{the sorted vector of the censorship.}
\item{sortebz}{the sorted matrix of the covariates.}
\item{ch}{the Hill estimator associated to the baseline function.}
\item{TestingGrid}{the grid used for the statistic test.}
\item{TS,TS1,TS.max,TS1.max}{respectively the test statistic, the likelihood ratio test, the maximum of the test statistic and the maximum likelihood ratio test.}
\item{window1,window2}{indices from which the threshold was chosen.}
\item{Paretodata}{logical: if TRUE the distribution of the data is a Pareto distribution.}
\item{Paretotail}{logical: if TRUE a Pareto tail was detected.}
\item{madapt}{the first indice of the TestingGrid for which the test statistic exceeds the critical value.}
\item{kadapt}{the adaptive indice of the threshold.}
\item{kadapt.maxlik}{the maximum likelihood corresponding to the adaptive threshold in the selected testing grid.}
\item{hadapt}{the adaptive weighted parameter of the Pareto distribution after the threshold.}
\item{Xadapt}{the adaptive threshold.}
}
\description{
Compute the extreme quantile procedure for Cox model
}
\details{
Given a vector of data, a vector of censorship and a data frame of covariates, this function compute the adaptive procedure described in Grama and Jaunatre (2018).

We suppose that the data are in the domain of attraction of the Frechet-Pareto type and that the hazard are somewhat proportionals. Otherwise, the procedure will not work.
}
\examples{

library(survival)
data(bladder)

X <- bladder2$stop-bladder2$start
Z <- as.matrix(bladder2[, c(2:4, 8)])
delta <- bladder2$event

ord <- order(X)
X <- X[ord]
Z <- Z[ord,]
delta <- delta[ord]

cph<-coxph(Surv(X, delta) ~ Z)

ca <- cox.adapt(X, cph, delta, Z)

}
\references{
Grama, I. and Jaunatre, K. (2018). Estimation of Extreme Survival Probabilities with Cox Model. arXiv:1805.01638.
}
\seealso{
\code{\link[survival]{coxph}}
}
\author{
Ion Grama, Kevin Jaunatre
}
