% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{Pareto mix}
\alias{Pareto mix}
\alias{pparetomix}
\alias{dparetomix}
\alias{qparetomix}
\alias{rparetomix}
\title{Pareto mixture distribution}
\usage{
pparetomix(q, a = 1, b = 2, c = 0.75)

dparetomix(x, a = 1, b = 2, c = 0.75)

qparetomix(p, a = 1, b = 2, c = 0.75, precision = 10^(-10),
  initvalue = 0.5, Nmax = 1000)

rparetomix(n, a = 1, b = 2, c = 0.75, precision = 10^(-10))
}
\arguments{
\item{q}{a vector of quantiles.}

\item{a}{the shape parameter of the first Pareto Distribution.}

\item{b}{the shape parameter of the second Pareto Distribution.}

\item{c}{the value of the mixture proportion.}

\item{x}{a vector of quantiles.}

\item{p}{a vector of probabilities.}

\item{precision}{the precision of the Newton method.}

\item{initvalue}{the initial value of the Newton method.}

\item{Nmax}{the maximum of iteration done for the Newton method.}

\item{n}{the number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
dparetomix gives the density, pparetomix gives the distribution function, qparetomix gives the quantile function, and rparetomix generates random deviates.

The length of the result is determined by n for rparetomix, and is the maximum of the lengths of the numerical arguments for the other functions.

The numerical arguments other than n are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
\description{
Density, distribution function, quantile function and random generation for the Pareto mixture distribution with \eqn{a} equal to the shape of the first Pareto Distribution, \eqn{b} equal to the shape of the second Pareto Distribution and \eqn{c} is the mixture proportion. The locations and the scales parameters are equals to \eqn{0} and \eqn{1}.
}
\details{
If the \eqn{a}, \eqn{b} and \eqn{c} are not specified, they respectively take the default values \eqn{1}, \eqn{2} and \eqn{0.75}.

The cumulative Pareto mixture distribution is
\deqn{
  F(x) = c  (1- x ^ {-a}) + ( 1 - c ) (1 - x ^ {-b}),  x \ge 1,  a >0,  b > 0, 0 \le c \le 1
}
where \eqn{a} and \eqn{b} are the shapes of the distribution and \eqn{c} is the mixture proportion.
}
\examples{
par(mfrow = c(3,1))
plot(function(x) dparetomix(x), 0, 5,ylab="density",
     main = " Pareto mixture density ")
mtext("dparetomix(x)", adj = 0)

plot(function(x) pparetomix(x), 0, 5,ylab="distribution function",
     main = " Pareto mixture Cumulative ")
mtext("pparetomix(x)", adj = 0)

plot(function(x) qparetomix(x), 0, 1,ylim=c(0,5),ylab="quantiles",
     main = " Pareto mixture Quantile ")
mtext("qparetomix(x)", adj = 0)

#generate a sample of the Pareto mix distribution of size n
n <- 100
x <- rparetomix(n)


}
