% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distLgofPlot.R
\name{distLgofPlot}
\alias{distLgofPlot}
\title{Distribution rank comparison}
\usage{
distLgofPlot(dlf, ranks = TRUE, weights = TRUE, nbest = NA,
  order = TRUE, add = FALSE, type = "o", col = c(1, 3, 4), pch = 1:3,
  lty = 1, legargs = NULL, quiet = FALSE, main = NULL, ...)
}
\arguments{
\item{dlf}{List as returned by \code{\link{distLfit}}, containing the elements \code{gof, gofProp}}

\item{ranks}{plot ranks by different measures of goodness of fit? DEFAULT: TRUE}

\item{weights}{plot weights in second panel? DEFAULT: TRUE}

\item{nbest}{Number of distributions plotted by \code{\link{distLplot}}. DEFAULT: NA}

\item{order}{If TRUE, the best distribution is at the top. False to compare across different dlfs. DEFAULT: TRUE}

\item{add}{If TRUE, just the lines and legend are added to an existing plot. DEFAULT: FALSE}

\item{type}{type of line-point combination as in \code{\link{plot}}. DEFAULT: "o"}

\item{col}{Vector with 3 values for line customization. Recycled if necessary. DEFAULT: c(1,3,4)}

\item{pch}{Vector with 3 values for line customization. Recycled if necessary. DEFAULT: 1:3}

\item{lty}{Vector with 3 values for line customization. Recycled if necessary. DEFAULT: 1}

\item{legargs}{List of arguments passed to \code{\link{legend}} if weights=TRUE, like cex, bg, etc.}

\item{quiet}{Suppress notes? DEFAULT: FALSE}

\item{main}{plot titles. DEFAULT: NULL}

\item{\dots}{Further arguments passed to \code{\link{plot}}.}
}
\value{
None.
}
\description{
Plot rank comparison of fitted distributions calculated by \code{\link{distLgof}}.
}
\examples{
# see distLgof

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Sept 2014
}
\seealso{
\code{\link{distLgof}}, \code{\link{distLfit}}
}
\keyword{distribution}
\keyword{hplot}

