% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_labels.R
\name{write_labels}
\alias{write_labels}
\alias{read_labelled_csv}
\alias{read_labelled_csv2}
\alias{read_labelled_tab}
\alias{read_labelled_tab2}
\alias{write_labelled_csv}
\alias{write_labelled_csv2}
\alias{write_labelled_tab}
\alias{write_labelled_tab2}
\alias{write_labelled_spss}
\alias{write_labels_spss}
\title{Write data with labels to file in R code or in SPSS syntax.}
\usage{
write_labels(x, filename, fileEncoding = "")

read_labelled_csv(filename, fileEncoding = "", encoding = "unknown",
  sep = ",", dec = ".", undouble_quotes = TRUE, ...)

read_labelled_csv2(filename, fileEncoding = "", encoding = "unknown",
  sep = ";", dec = ",", undouble_quotes = TRUE, ...)

read_labelled_tab(filename, fileEncoding = "", encoding = "unknown",
  sep = "\\t", dec = ".", undouble_quotes = TRUE, ...)

read_labelled_tab2(filename, fileEncoding = "", encoding = "unknown",
  sep = "\\t", dec = ",", undouble_quotes = TRUE, ...)

write_labelled_csv(x, filename, fileEncoding = "", sep = ",",
  dec = ".", qmethod = c("double", "escape"),
  remove_new_lines = TRUE, ...)

write_labelled_csv2(x, filename, fileEncoding = "", sep = ";",
  dec = ",", qmethod = c("double", "escape"),
  remove_new_lines = TRUE, ...)

write_labelled_tab(x, filename, fileEncoding = "", sep = "\\t",
  dec = ".", qmethod = c("double", "escape"),
  remove_new_lines = TRUE, ...)

write_labelled_tab2(x, filename, fileEncoding = "", sep = "\\t",
  dec = ",", qmethod = c("double", "escape"),
  remove_new_lines = TRUE, ...)

write_labelled_spss(x, filename, fileEncoding = "",
  remove_new_lines = TRUE, ...)

write_labels_spss(x, filename)
}
\arguments{
\item{x}{data.frame to be written/data.frame whose labels to be written}

\item{filename}{the name of the file which the data are to be read from/write to.}

\item{fileEncoding}{character string: if non-empty declares the encoding to 
be used on a file (not a connection) so the character data can be 
re-encoded as they are written. Used for writing dictionary. See
\link[base]{file}.}

\item{encoding}{default is "unknown". Other possible options are "UTF-8" and 
"Latin-1". Note: it is not used to re-encode the input, rather enables 
handling of encoded strings in their native encoding. Used for writing data
file. See \link[data.table]{fread}.}

\item{sep}{the field separator string. Values within each row of x are
separated by this string.}

\item{dec}{the string to use for decimal points in numeric or complex
columns: must be a single character.}

\item{undouble_quotes}{A logical indicating should we undouble quotes which
were escaped by doubling (see \code{qmethod}). TRUE by default. Argument
will be removed when data.table issue #1109 will be fixed.}

\item{...}{additional arguments for
\link[data.table]{fwrite}/\link[data.table]{fread}}

\item{qmethod}{A character string specifying how to deal with embedded double
quote characters when quoting strings. "escape" - the quote character (as
well as the backslash character) is escaped in C style by a
backslash, or "double" (default), in which case the double quote is doubled with
another one.}

\item{remove_new_lines}{A logical indicating should we replace new lines with spaces in
the character variables. TRUE by default.}
}
\value{
Functions for writing invisibly return NULL. Functions for reading
  return labelled data.frame.
}
\description{
\code{write_labelled_*} functions write data in the CSV format and file with 
R code/SPSS syntax for labelling data.  SPSS syntax also contains code for 
reading data in SPSS. \code{write_labelled_*} doesn't save rownames of 
data.frame. \code{write_labels_*} functions write R code/SPSS syntax for 
labelling data. It allows to extract labels from *.sav files that come 
without accompanying syntax. \code{read_labelled_csv} reads data file in CSV 
format and apply labels from accompanying file with R code. \code{*_csv2} 
write/read data with semicolon separator and comma as decimal delimiter. 
\code{*_tab/*_tab2} write/read data with tab separator and "."/"," as
decimal delimiter.
}
\examples{
\dontrun{
data(mtcars)
mtcars = modify(mtcars,{
                var_lab(mpg) = "Miles/(US) gallon"
                var_lab(cyl) = "Number of cylinders"
                var_lab(disp) = "Displacement (cu.in.)"
                var_lab(hp) = "Gross horsepower"
                var_lab(drat) = "Rear axle ratio"
                var_lab(wt) = "Weight (lb/1000)"
                var_lab(qsec) = "1/4 mile time"
                var_lab(vs) = "Engine"
                val_lab(vs) = c("V-engine" = 0, 
                                "Straight engine" = 1) 
                var_lab(am) = "Transmission"
                val_lab(am) = c(automatic = 0, 
                                manual=1)
                var_lab(gear) = "Number of forward gears"
                var_lab(carb) = "Number of carburetors"
})

# to R code
# rownames are not preserved
write_labelled_csv(mtcars, "mtcars.csv")
new_mtcars = read_labelled_csv("mtcars.csv")

# to SPSS syntax
write_labelled_spss(mtcars, "mtcars.csv")

}
}
