% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_fun.R, R/deprecated_cro.R
\name{cross_fun}
\alias{cross_fun}
\alias{cross_fun_df}
\alias{cross_mean}
\alias{cross_mean_sd_n}
\alias{cross_sum}
\alias{cross_median}
\alias{cross_pearson}
\alias{cross_spearman}
\alias{cro_fun}
\alias{cro_fun_df}
\alias{cro_mean}
\alias{cro_mean_sd_n}
\alias{cro_sum}
\alias{cro_median}
\alias{cro_pearson}
\alias{cro_spearman}
\alias{combine_functions}
\alias{calc_cro_fun}
\alias{calc_cro_fun_df}
\alias{calc_cro_mean}
\alias{calc_cro_mean_sd_n}
\alias{calc_cro_sum}
\alias{calc_cro_median}
\alias{calc_cro_pearson}
\alias{calc_cro_spearman}
\title{Cross-tabulation with custom summary function.}
\usage{
cross_fun(
  data,
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL,
  fun,
  ...,
  unsafe = FALSE
)

cross_fun_df(
  data,
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL,
  fun,
  ...,
  unsafe = FALSE
)

cross_mean(
  data,
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL
)

cross_mean_sd_n(
  data,
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL,
  weighted_valid_n = FALSE,
  labels = NULL
)

cross_sum(
  data,
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL
)

cross_median(
  data,
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL
)

cross_pearson(
  data,
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL
)

cross_spearman(
  data,
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL
)

cro_fun(
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL,
  fun,
  ...,
  unsafe = FALSE
)

cro_fun_df(
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL,
  fun,
  ...,
  unsafe = FALSE
)

cro_mean(
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL
)

cro_mean_sd_n(
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL,
  weighted_valid_n = FALSE,
  labels = NULL
)

cro_sum(
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL
)

cro_median(
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL
)

cro_pearson(
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL
)

cro_spearman(
  cell_vars,
  col_vars = total(),
  row_vars = total(label = ""),
  weight = NULL,
  subgroup = NULL
)

combine_functions(..., method = c)
}
\arguments{
\item{data}{data.frame in which context all other arguments will be evaluated
(for \code{cross_*}).}

\item{cell_vars}{vector/data.frame/list. Variables on which summary function
will be computed.}

\item{col_vars}{vector/data.frame/list. Variables which breaks table by
columns. Use \link{mrset}/\link{mdset} for multiple-response variables.}

\item{row_vars}{vector/data.frame/list. Variables which breaks table by rows.
Use \link{mrset}/\link{mdset} for multiple-response variables.}

\item{weight}{numeric vector. Optional cases weights. Cases with NA's,
negative and zero weights are removed before calculations.}

\item{subgroup}{logical vector. You can specify subgroup on which table will be computed.}

\item{fun}{custom summary function. Generally it is recommended that 
\code{fun} will always return object of the same form. Rownames/vector 
names of \code{fun} result will appear in the row labels of the table and 
column names/names of list will appear in the column labels. To use weight 
you should have formal \code{weight} argument in \code{fun} and some logic 
for its processing inside. For \code{cro_fun_df} \code{fun} will receive 
\link[data.table]{data.table} with all names converted to variable labels
(if labels exists). So it is not recommended to rely on original variables
names in your \code{fun}.}

\item{...}{further arguments for \code{fun}  in 
\code{cross_fun}/\code{cross_fun_df} or functions for \code{combine_functions}.
Ignored in \code{cross_fun}/\code{cross_fun_df} if \code{unsafe} is TRUE.}

\item{unsafe}{logical/character If not FALSE than \code{fun} will be 
evaluated as is. It can lead to significant increase in the performance. 
But there are some limitations. For \code{cross_fun} it means that your 
function \code{fun} should return vector. If length of this vector is
greater than one than you should provide with \code{unsafe} argument vector
of unique labels for each element of this vector. There will be no attempts
to automatically make labels for the results of \code{fun}. For 
\code{cross_fun_df} your function should return vector or list/data.frame
(optionally with 'row_labels' element - statistic labels). If \code{unsafe}
is TRUE or not logical then further arguments (\code{...}) for \code{fun}
will be ignored.}

\item{weighted_valid_n}{logical. Should we show weighted valid N in
\code{cro_mean_sd_n}? By default it is FALSE.}

\item{labels}{character vector of length 3. Labels for mean, standard
deviation and valid N in \code{cro_mean_sd_n}.}

\item{method}{function which will combine results of multiple functions in
\code{combine_functions}. It will be applied as in the expression 
\code{do.call(method, list_of_functions_results)}. By default it is
\code{c}.}
}
\value{
object of class 'etable'. Basically it's a data.frame but class
  is needed for custom methods.
}
\description{
\itemize{
\item{\code{cross_mean}, \code{cross_sum}, \code{cross_median}}{ calculate 
mean/sum/median by groups. NA's are always omitted.}
\item{\code{cross_mean_sd_n}}{ calculates mean, standard deviation and N
simultaneously. Mainly intended for usage with \link{significance_means}.}
\item{\code{cross_pearson}, \code{cross_spearman}}{ calculate correlation of 
first variable in each data.frame in \code{cell_vars} with other variables. 
NA's are removed pairwise.}
\item{\code{cross_fun}, \code{cross_fun_df}}{ return table with custom summary 
statistics defined by \code{fun} argument. NA's treatment depends on your 
\code{fun} behavior. To use weight you should have formal \code{weight} 
argument in \code{fun} and some logic for its processing inside. Several 
functions with weight support are provided - see \link{w_mean}. 
\code{cross_fun} applies \code{fun} on each variable in \code{cell_vars} 
separately, \code{cross_fun_df} gives to \code{fun} each data.frame in 
\code{cell_vars} as a whole. So \code{cross_fun(iris[, -5], iris$Species, fun =
mean)} gives the same result as \code{cross_fun_df(iris[, -5], iris$Species, 
fun = colMeans)}. For \code{cross_fun_df} names of \code{cell_vars} will 
converted to labels if they are available before the \code{fun} will be applied. 
Generally it is recommended that \code{fun} will always return object of the 
same form. Row names/vector names of \code{fun} result will appear in the row
labels of the table and column names/names of list will appear in the column 
labels. If your \code{fun} returns data.frame/matrix/list with element named
'row_labels' then this element will be used as row labels. And it will have
precedence over rownames.}
\item{\code{cross_*}}{ are evaluate their arguments
in the context of the first argument \code{data}.}
\item{\code{cro_*}}{ functions use standard evaluation, e. g 'cro(mtcars$am, mtcars$vs)'.}
\item{\code{combine_functions}}{ is auxiliary function for combining several 
functions into one function for usage with \code{cro_fun}/\code{cro_fun_df}.
Names of arguments will be used as statistic labels. By default, results of
each function are combined with \link{c}. But you can provide your own method
function with \code{method} argument. It will be applied as in the expression
\code{do.call(method, list_of_functions_results)}. Particular useful method
is \code{list}. When it used then statistic labels will appear in the column
labels. See examples. Also you may be interested in \code{data.frame}, 
\code{rbind}, \code{cbind} methods.}}
}
\examples{
data(mtcars)
mtcars = apply_labels(mtcars,
                      mpg = "Miles/(US) gallon",
                      cyl = "Number of cylinders",
                      disp = "Displacement (cu.in.)",
                      hp = "Gross horsepower",
                      drat = "Rear axle ratio",
                      wt = "Weight (1000 lbs)",
                      qsec = "1/4 mile time",
                      vs = "Engine",
                      vs = c("V-engine" = 0,
                             "Straight engine" = 1),
                      am = "Transmission",
                      am = c("Automatic" = 0,
                             "Manual"=1),
                      gear = "Number of forward gears",
                      carb = "Number of carburetors"
)


# Simple example - there is special shortcut for it - 'cross_mean'
cross_fun(mtcars, 
          list(mpg, disp, hp, wt, qsec), 
          col_vars = list(total(), am), 
          row_vars = vs, 
          fun = mean)



# The same example with 'subgroup'
cross_fun(mtcars, 
       list(mpg, disp, hp, wt, qsec), 
       col_vars = list(total(), am), 
       row_vars = vs, 
       subgroup = vs == 0, 
       fun = mean)
                                
# 'combine_functions' usage  
cross_fun(mtcars, 
          list(mpg, disp, hp, wt, qsec), 
          col_vars = list(total(), am), 
          row_vars = vs, 
          fun = combine_functions(Mean = mean, 
                                  'Std. dev.' = sd,
                                  'Valid N' = valid_n)
)

# 'combine_functions' usage - statistic labels in columns
cross_fun(mtcars, 
          list(mpg, disp, hp, wt, qsec), 
          col_vars = list(total(), am), 
          row_vars = vs, 
          fun = combine_functions(Mean = mean, 
                                  'Std. dev.' = sd,
                                  'Valid N' = valid_n,
                                  method = list
                                  )
)

# 'summary' function
cross_fun(mtcars, 
          list(mpg, disp, hp, wt, qsec), 
          col_vars = list(total(), am), 
          row_vars = list(total(), vs), 
          fun = summary
) 
                          
# comparison 'cross_fun' and 'cross_fun_df'
cross_fun(mtcars,
          data.frame(mpg, disp, hp, wt, qsec), 
          col_vars = am,
          fun = mean
)


# same result
cross_fun_df(mtcars,
             data.frame(mpg, disp, hp, wt, qsec), 
             col_vars = am, 
             fun = colMeans
             )

# usage for 'cross_fun_df' which is not possible for 'cross_fun'
# linear regression by groups
cross_fun_df(mtcars,
             data.frame(mpg, disp, hp, wt, qsec), 
             col_vars = am,
             fun = function(x){
                 frm = reformulate(".", response = as.name(names(x)[1]))
                 model = lm(frm, data = x)
                 cbind('Coef.' = coef(model), 
                       confint(model)
                 )
             } 
)
}
\seealso{
\link{tables}, \link{fre}, \link{cross_cases}.
}
