% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_labels.R
\name{apply_labels}
\alias{apply_labels}
\alias{.apply_labels}
\title{Set variable labels/value labels on variables in the data.frame}
\usage{
apply_labels(data, ...)

.apply_labels(...)
}
\arguments{
\item{data}{data.frame/list}

\item{...}{named arguments. Name of argument is a variable name in
\code{data}. Argument values are variable or value labels. Unnamed
characters of length 1 are considered as variable labels and named vectors
are considered as value labels.}
}
\value{
\code{data} with applied labels
}
\description{
\code{apply_labels} tries automatically detect what is variable label and
what are value labels. \code{.apply_labels} is version for working
with default dataset. See also \link{var_lab} and \link{val_lab}.
}
\examples{
data(mtcars)
mtcars = apply_labels(mtcars,
                      vs = "Engine",
                      vs = num_lab("
                             0 V-engine 
                             1 Straight engine
                             "),
                      am = "Transmission",
                      am = num_lab("
                             0 Automatic 
                             1 Manual
                             ")
)

# 'table' from base R
table(mtcars$vs, mtcars$am)

# more sofisticated crosstable
calculate(mtcars, cro(vs, am))

}
