% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-mod.R
\name{modSkew}
\alias{modSkew}
\title{Skew Data by Factor Range}
\usage{
modSkew(object, alpha = 0, uniform = TRUE)
}
\arguments{
\item{object}{An \code{ExprsArray} object. The object that should undergo a
replication of some feature selection and dimension reduction history.}

\item{alpha}{An integer. The maximum range of skew factors used
for skewing if \code{uniform = TRUE}. The standard deviation
of the skew factors if \code{uniform = FALSE}. See Details.}

\item{uniform}{A boolean. Toggles whether to draw skew factors
from a uniform distribution or a normal distribution.}
}
\value{
A pre-processed \code{ExprsArray} object.
}
\description{
\code{modSkew} skews a data set by making all sample vectors
 have the same total sum, introducing a new feature, and then
 making all sample vectors again have the same total sum.
}
\details{
If \code{uniform = TRUE}, skew factors are randomly sampled from
 the uniform distribution \code{(0, alpha) + 1}. Otherwise, skew
 factors are randomly sampled from the normal distribution with
 a mean of 0 and standard deviation of \code{alpha}. When using
 the normal distribution, these skew factors are transformed by
 taking the absolute value then adding one. For this reason,
 data are always unskewed when \code{alpha = 0}.
}
