% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6.2-calc.R
\docType{methods}
\name{calcStats}
\alias{calcStats}
\alias{calcStats,ExprsPredict-method}
\alias{calcStats,RegrsPredict-method}
\title{Calculate Model Performance}
\usage{
calcStats(object, aucSkip = FALSE, plotSkip = FALSE, verbose = TRUE)

\S4method{calcStats}{ExprsPredict}(object, aucSkip = FALSE,
  plotSkip = FALSE, verbose = TRUE)

\S4method{calcStats}{RegrsPredict}(object, aucSkip = FALSE,
  plotSkip = FALSE, verbose = TRUE)
}
\arguments{
\item{object}{An \code{ExprsPredict} or \code{RegrsPredict} object.}

\item{aucSkip}{A logical scalar. Toggles whether to calculate area under the
receiver operating characteristic curve. See Details.}

\item{plotSkip}{A logical scalar. Toggles whether to plot the receiver
operating characteristic curve. See Details.}

\item{verbose}{A logical scalar. Toggles whether to print the results
of model performance to console.}
}
\value{
Returns a \code{data.frame} of performance metrics.
}
\description{
\code{calcStats} calculates the performance of a deployed model.
}
\details{
For classification, if the argument \code{aucSkip = FALSE} AND the \code{ExprsArray}
 object was an \code{ExprsBinary} object with at least one case and one control AND
 \code{ExprsPredict} contains a coherent \code{@probability} slot, \code{calcStats}
 will calculate classifier performance using the area under the receiver operating
 characteristic (ROC) curve via the \code{ROCR} package. Otherwise, \code{calcStats}
 will calculate classifier performance traditionally using a confusion matrix.
 Note that accuracies calculated using \code{ROCR} may differ from those calculated
 using a confusion matrix because \code{ROCR} adjusts the discrimination threshold to
 optimize sensitivity and specificity. This threshold is automatically chosen as the
 point along the ROC which minimizes the Euclidean distance from (0, 1).

For regression, accuracy is defined the R-squared of the fitted regression. This
 ranges from 0 to 1 for use with \code{\link{pl}} and \code{\link{pipe}}. Note that
 the \code{aucSkip} and \code{plotSkip} arguments are ignored for regression.
}
\section{Methods (by class)}{
\itemize{
\item \code{ExprsPredict}: Method to calculate performance for classification models.

\item \code{RegrsPredict}: Method to calculate performance for continuous outcome models.
}}

