% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-split.R
\name{splitSample}
\alias{splitSample}
\title{Split by Random Sampling}
\usage{
splitSample(object, percent.include = 67, ...)
}
\arguments{
\item{object}{An \code{ExprsArray} object to split.}

\item{percent.include}{Specifies the percent of the total number
of subjects to include in the training set.}

\item{...}{For \code{splitSample}: additional arguments passed
along to \code{\link{sample}}. For \code{splitStratify}: additional
arguments passed along to \code{\link{cut}}.}
}
\value{
Returns a list of two \code{ExprsArray} objects.
}
\description{
\code{splitSample} builds a training and validation set by randomly sampling
 the subjects found within the \code{ExprsArray} object. Note that this method
 is not truly random. Instead, \code{splitSample} iterates through the random sampling
 process until it settles on a solution such that both the training and validation set
 contain at least one subject for each class label. If this method finds no solution
 after 10 iterations, the function will post an error. Set \code{percent.include = 100}
 to skip random sampling and return a \code{NULL} validation set. Additional arguments
 (e.g., \code{replace = TRUE}) passed along to \code{\link{sample}}. This method works well
 for all (i.e., binary and multi-class) \code{ExprsArray} objects.
}
