% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2.1-import.R
\name{arrayExprs}
\alias{arrayExprs}
\title{Import Data as ExprsArray}
\usage{
arrayExprs(object, colBy, include, colID, begin, ...)
}
\arguments{
\item{object}{What to import as an \code{ExprsArray} object. See Details.}

\item{colBy}{A numeric or character index. The column that contains group annotations.}

\item{include}{A list of character vectors. Specifies which annotations in \code{colBy}
to include in which groups. Each element of the list specifies a unique group while
each element of the character vector specifies which annotations define that group. For
binary classification, the first list element defines the negative, or control, group.}

\item{colID}{A numeric or character index. The column used to name subjects.
For \code{data.frame} or file import only.}

\item{begin}{A numeric scalar. The j-th column at which feature data starts.
For \code{data.frame} or file import only.}

\item{...}{Additional arguments passed along to \code{read.delim}.
For file import only.}
}
\value{
An \code{ExprsArray} object.
}
\description{
A convenience function that builds an \code{ExprsArray} object.
}
\details{
Importing a \code{data.frame} object:

This function expects that the imported \code{data.frame} has the following format:
 rows indicate subject entries while columns indicate measured variables.
 The first several columns should contain annotation information (e.g., age, sex, diagnosis).
 The remaining columns should contain feature data (e.g., expression values).
 The argument \code{begin} defines the j-th column at which the feature
 data starts. This function automatically removes any features with \code{NA} values.
 Take care to remove any \code{factor} columns before importing.

Importing an \code{ExpressionSet} object:

The package Biobase maintains a popular class object called \code{ExpressionSet} that
 often gets used to store expression data. This function converts this \code{eSet}
 object into an \code{ExprsArray} object. This function automatically removes any
 features with \code{NA} values.

Importing a \code{file}:

\code{arrayExprs} can also build an \code{ExprsArray} object from a tab-delimited
 data file, passing along the \code{file} and \code{...} argument(s) to
 \code{\link{read.delim}}. All rules for \code{data.frame} import also apply here.
 By default, \code{arrayExprs} forces \code{stringsAsFactors = FASE}.
}
\seealso{
\code{\link{ExprsArray-class}}, \code{\link{GSE2eSet}}
}

