% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sink.R
\name{sink}
\alias{sink}
\title{A variational approximation of an expected permutation matrix}
\usage{
sink(A, maxit = 99)
}
\arguments{
\item{A}{A matrix of assignment likelihoods.}

\item{maxit}{An integer specifying the maximum number of steps used in the optimization.}
}
\value{
\code{E(P)}, the expected permutation matrix corresponding to \code{A}.
}
\description{
Computes an approximate expected permutation matrix and marginal likelihood from a matrix of assignment likelihoods. The approximation minimizes a constrained KL divergence from the likelihood, and is computed via the repeated renormalization of the input's rows and columns.
}
\examples{
data(A)
sink(A)
}
